/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.util.concurrent;

import io.skylite.common.lease.Releasable;
import io.skylite.common.util.concurrent.ConcurrentCollections;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class KeyedLock<T> {
    private final ConcurrentMap<T, KeyLock> map = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final boolean fair;

    public KeyedLock(boolean fair) {
        this.fair = fair;
    }

    public KeyedLock() {
        this(false);
    }

    public Releasable acquire(T key) {
        KeyLock perNodeLock;
        while (true) {
            if ((perNodeLock = (KeyLock)this.map.get(key)) == null) {
                ReleasableLock newLock = this.tryCreateNewLock(key);
                if (newLock == null) continue;
                return newLock;
            }
            assert (perNodeLock != null);
            int i = perNodeLock.count.get();
            if (i > 0 && perNodeLock.count.compareAndSet(i, i + 1)) break;
        }
        perNodeLock.lock();
        return new ReleasableLock(key, perNodeLock);
    }

    public Releasable tryAcquire(T key) {
        KeyLock perNodeLock = (KeyLock)this.map.get(key);
        if (perNodeLock == null) {
            return this.tryCreateNewLock(key);
        }
        if (perNodeLock.tryLock()) {
            int i;
            while ((i = perNodeLock.count.get()) > 0) {
                if (!perNodeLock.count.compareAndSet(i, i + 1)) continue;
                return new ReleasableLock(key, perNodeLock);
            }
            perNodeLock.unlock();
        }
        return null;
    }

    private ReleasableLock tryCreateNewLock(T key) {
        KeyLock newLock = new KeyLock(this.fair);
        newLock.lock();
        KeyLock keyLock = this.map.putIfAbsent(key, newLock);
        if (keyLock == null) {
            return new ReleasableLock(key, newLock);
        }
        return null;
    }

    public boolean isHeldByCurrentThread(T key) {
        KeyLock lock = (KeyLock)this.map.get(key);
        if (lock == null) {
            return false;
        }
        return lock.isHeldByCurrentThread();
    }

    private void release(T key, KeyLock lock) {
        assert (lock == this.map.get(key));
        int decrementAndGet = lock.count.decrementAndGet();
        lock.unlock();
        if (decrementAndGet == 0) {
            this.map.remove(key, lock);
        }
        assert (decrementAndGet >= 0) : decrementAndGet + " must be >= 0 but wasn't";
    }

    public boolean hasLockedKeys() {
        return !this.map.isEmpty();
    }

    private static final class KeyLock
    extends ReentrantLock {
        private final AtomicInteger count = new AtomicInteger(1);

        KeyLock(boolean fair) {
            super(fair);
        }
    }

    private final class ReleasableLock
    implements Releasable {
        final T key;
        final KeyLock lock;
        final AtomicBoolean closed = new AtomicBoolean();

        private ReleasableLock(T key, KeyLock lock) {
            this.key = key;
            this.lock = lock;
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                KeyedLock.this.release(this.key, this.lock);
            }
        }
    }
}

