/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.util.concurrent;

import io.skylite.common.metrics.CounterMetric;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.common.util.concurrent.SizeBlockingQueue;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.common.util.concurrent.XRejectedExecutionHandler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

public class SkyliteAbortPolicy
implements XRejectedExecutionHandler {
    private final CounterMetric rejected = new CounterMetric();

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (r instanceof AbstractRunnable && ((AbstractRunnable)r).isForceExecution()) {
            BlockingQueue<Runnable> queue = executor.getQueue();
            if (!(queue instanceof SizeBlockingQueue)) {
                throw new IllegalStateException("forced execution, but expected a size queue");
            }
            try {
                ((SizeBlockingQueue)queue).forcePut(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("forced execution, but got interrupted", e);
            }
            return;
        }
        this.rejected.inc();
        throw new SkyliteRejectedExecutionException("rejected execution of " + String.valueOf(r) + " on " + String.valueOf(executor), executor.isShutdown());
    }

    @Override
    public long rejected() {
        return this.rejected.count();
    }
}

