/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.script.mustache;

import io.lucenia.script.mustache.SearchTemplateRequest;
import io.lucenia.script.mustache.SearchTemplateRequestBuilder;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.CompositeIndicesRequest;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultiSearchTemplateRequest
extends ActionRequest
implements CompositeIndicesRequest {
    private int maxConcurrentSearchRequests = 0;
    private List<SearchTemplateRequest> requests = new ArrayList<SearchTemplateRequest>();
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosedIgnoreThrottled();

    public MultiSearchTemplateRequest() {
    }

    public MultiSearchTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.maxConcurrentSearchRequests = in.readVInt();
        this.requests = in.readList(SearchTemplateRequest::new);
    }

    public MultiSearchTemplateRequest add(SearchTemplateRequestBuilder request) {
        this.requests.add((SearchTemplateRequest)request.request());
        return this;
    }

    public MultiSearchTemplateRequest add(SearchTemplateRequest request) {
        this.requests.add(request);
        return this;
    }

    public int maxConcurrentSearchRequests() {
        return this.maxConcurrentSearchRequests;
    }

    public MultiSearchTemplateRequest maxConcurrentSearchRequests(int maxConcurrentSearchRequests) {
        if (maxConcurrentSearchRequests < 1) {
            throw new IllegalArgumentException("maxConcurrentSearchRequests must be positive");
        }
        this.maxConcurrentSearchRequests = maxConcurrentSearchRequests;
        return this;
    }

    public List<SearchTemplateRequest> requests() {
        return this.requests;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"no requests added", validationException);
        }
        for (SearchTemplateRequest request : this.requests) {
            ActionRequestValidationException ex = request.validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors((Iterable)ex.validationErrors());
        }
        return validationException;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public MultiSearchTemplateRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.maxConcurrentSearchRequests);
        out.writeList(this.requests);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MultiSearchTemplateRequest that = (MultiSearchTemplateRequest)((Object)o);
        return this.maxConcurrentSearchRequests == that.maxConcurrentSearchRequests && Objects.equals(this.requests, that.requests) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.maxConcurrentSearchRequests, this.requests, this.indicesOptions);
    }

    public static byte[] writeMultiLineFormat(MultiSearchTemplateRequest multiSearchTemplateRequest, XContent xContent) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (SearchTemplateRequest templateRequest : multiSearchTemplateRequest.requests()) {
            SearchRequest searchRequest = templateRequest.getRequest();
            try (XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)xContent);){
                MultiSearchRequest.writeSearchRequestParams((SearchRequest)searchRequest, (XContentBuilder)xContentBuilder);
                BytesReference.bytes((XContentBuilder)xContentBuilder).writeTo((OutputStream)output);
            }
            output.write(xContent.streamSeparator());
            xContentBuilder = XContentBuilder.builder((XContent)xContent);
            try {
                templateRequest.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                BytesReference.bytes((XContentBuilder)xContentBuilder).writeTo((OutputStream)output);
            }
            finally {
                if (xContentBuilder != null) {
                    xContentBuilder.close();
                }
            }
            output.write(xContent.streamSeparator());
        }
        return output.toByteArray();
    }
}

