/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.script.mustache;

import io.lucenia.script.mustache.MultiSearchTemplateAction;
import io.lucenia.script.mustache.MultiSearchTemplateRequest;
import io.lucenia.script.mustache.SearchTemplateRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.rest.action.search.RestMultiSearchAction;
import org.opensearch.rest.action.search.RestSearchAction;

public class RestMultiSearchTemplateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS;
    private final boolean allowExplicitIndex;

    public RestMultiSearchTemplateAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_msearch/template")));
    }

    public String getName() {
        return "multi_search_template_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchTemplateRequest multiRequest = RestMultiSearchTemplateAction.parseRequest(request, this.allowExplicitIndex);
        return channel -> client.execute((ActionType)MultiSearchTemplateAction.INSTANCE, (ActionRequest)multiRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public static MultiSearchTemplateRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex) throws IOException {
        MultiSearchTemplateRequest multiRequest = new MultiSearchTemplateRequest();
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        RestMultiSearchAction.parseMultiLineRequest((RestRequest)restRequest, (IndicesOptions)multiRequest.indicesOptions(), (boolean)allowExplicitIndex, (searchRequest, bytes) -> {
            SearchTemplateRequest searchTemplateRequest = SearchTemplateRequest.fromXContent(bytes);
            if (searchTemplateRequest.getScript() == null) {
                throw new IllegalArgumentException("Malformed search template");
            }
            searchTemplateRequest.setRequest((SearchRequest)searchRequest);
            multiRequest.add(searchTemplateRequest);
            RestSearchAction.checkRestTotalHits((RestRequest)restRequest, (SearchRequest)searchRequest);
        });
        return multiRequest;
    }

    public boolean supportsContentStream() {
        return true;
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

