/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.script.mustache;

import io.lucenia.script.mustache.MultiSearchTemplateRequest;
import io.lucenia.script.mustache.MultiSearchTemplateResponse;
import io.lucenia.script.mustache.SearchTemplateRequest;
import io.lucenia.script.mustache.SearchTemplateResponse;
import io.lucenia.script.mustache.TransportSearchTemplateAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.search.MultiSearchRequest;
import io.skylite.core.action.search.MultiSearchResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;

public class TransportMultiSearchTemplateAction
extends HandledTransportAction<MultiSearchTemplateRequest, MultiSearchTemplateResponse> {
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final NodeClient client;

    @Inject
    public TransportMultiSearchTemplateAction(TransportService transportService, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NodeClient client) {
        super("indices:data/read/msearch/template", transportService, actionFilters, MultiSearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
    }

    protected void doExecute(Task task, MultiSearchTemplateRequest request, ActionListener<MultiSearchTemplateResponse> listener) {
        ArrayList<Integer> originalSlots = new ArrayList<Integer>();
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.indicesOptions(request.indicesOptions());
        if (request.maxConcurrentSearchRequests() != 0) {
            multiSearchRequest.maxConcurrentSearchRequests(request.maxConcurrentSearchRequests());
        }
        MultiSearchTemplateResponse.Item[] items = new MultiSearchTemplateResponse.Item[request.requests().size()];
        for (int i = 0; i < items.length; ++i) {
            SearchRequest searchRequest;
            SearchTemplateRequest searchTemplateRequest = request.requests().get(i);
            SearchTemplateResponse searchTemplateResponse = new SearchTemplateResponse();
            try {
                searchRequest = TransportSearchTemplateAction.convert(searchTemplateRequest, searchTemplateResponse, this.scriptService, this.xContentRegistry);
            }
            catch (Exception e) {
                items[i] = new MultiSearchTemplateResponse.Item(null, e);
                continue;
            }
            items[i] = new MultiSearchTemplateResponse.Item(searchTemplateResponse, null);
            if (searchRequest == null) continue;
            multiSearchRequest.add(searchRequest);
            originalSlots.add(i);
        }
        this.client.multiSearch(multiSearchRequest, ActionListenerHelper.wrap(r -> {
            for (int i = 0; i < r.getResponses().length; ++i) {
                MultiSearchResponse.Item item = r.getResponses()[i];
                int originalSlot = (Integer)originalSlots.get(i);
                if (item.isFailure()) {
                    items[originalSlot] = new MultiSearchTemplateResponse.Item(null, item.getFailure());
                    continue;
                }
                items[originalSlot].getResponse().setResponse(item.getResponse());
            }
            listener.onResponse((Object)new MultiSearchTemplateResponse(items, r.getTook().millis()));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

