/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.http.netty4;

import io.lucenia.http.netty4.Netty4HttpChannel;
import io.lucenia.http.netty4.Netty4HttpPipeliningHandler;
import io.lucenia.http.netty4.Netty4HttpRequestCreator;
import io.lucenia.http.netty4.Netty4HttpRequestHandler;
import io.lucenia.http.netty4.Netty4HttpResponseCreator;
import io.lucenia.http.netty4.Netty4HttpServerChannel;
import io.lucenia.transport.NettyAllocator;
import io.lucenia.transport.NettyByteBufSizer;
import io.lucenia.transport.SharedGroupFactory;
import io.lucenia.transport.netty4.Netty4Utils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.io.IOUtils;
import io.skylite.common.util.net.NetUtils;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.network.NetworkService;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.http.HttpServerTransport;
import io.skylite.core.http.HttpTransportSettings;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.http.AbstractHttpServerTransport;
import org.opensearch.http.HttpHandlingSettings;
import org.opensearch.http.HttpReadTimeoutException;
import org.opensearch.http.HttpServerChannel;

public class Netty4HttpServerTransport
extends AbstractHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(Netty4HttpServerTransport.class);
    private static final ByteSizeValue MTU = new ByteSizeValue(Long.parseLong(System.getProperty("opensearch.net.mtu", "1500")));
    private static final String SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = "http.netty.max_composite_buffer_components";
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = new Setting("http.netty.max_composite_buffer_components", s -> {
        ByteSizeValue maxContentLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(s);
        long maxBufferComponentsEstimate = Math.round((double)(maxContentLength.getBytes() / MTU.getBytes()));
        long maxBufferComponents = Math.max(2L, Math.min(maxBufferComponentsEstimate, Integer.MAX_VALUE));
        return String.valueOf(maxBufferComponents);
    }, s -> Setting.parseInt((String)s, (int)2, (int)Integer.MAX_VALUE, (String)SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT = Setting.intSetting((String)"http.netty.worker_count", (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"http.netty.receive_predictor_size", (ByteSizeValue)new ByteSizeValue(64L, ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ByteSizeValue maxInitialLineLength;
    private final ByteSizeValue maxHeaderSize;
    private final ByteSizeValue maxChunkSize;
    private final int pipeliningMaxEvents;
    private final SharedGroupFactory sharedGroupFactory;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final int readTimeoutMillis;
    private final int maxCompositeBufferComponents;
    private volatile ServerBootstrap serverBootstrap;
    private volatile SharedGroupFactory.SharedGroup sharedGroup;
    public static final AttributeKey<Netty4HttpChannel> HTTP_CHANNEL_KEY = AttributeKey.newInstance((String)"opensearch-http-channel");
    protected static final AttributeKey<Netty4HttpServerChannel> HTTP_SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"opensearch-http-server-channel");

    public Netty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, Tracer tracer) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, clusterSettings, tracer);
        Netty4Utils.setAvailableProcessors((Integer)SkyliteExecutors.NODE_PROCESSORS_SETTING.get(settings));
        NettyAllocator.logAllocatorDescriptionIfNeeded();
        this.sharedGroupFactory = sharedGroupFactory;
        this.maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.maxCompositeBufferComponents = (Integer)SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.readTimeoutMillis = Math.toIntExact(((TimeValue)HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings)).getMillis());
        ByteSizeValue receivePredictor = (ByteSizeValue)SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE.get(settings);
        this.recvByteBufAllocator = new FixedRecvByteBufAllocator(receivePredictor.bytesAsInt());
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}], max_composite_buffer_components[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictor, (Object)this.maxCompositeBufferComponents, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            ByteSizeValue tcpReceiveBufferSize;
            ByteSizeValue tcpSendBufferSize;
            this.sharedGroup = this.sharedGroupFactory.getHttpGroup();
            this.serverBootstrap = new ServerBootstrap();
            this.serverBootstrap.group(this.sharedGroup.getLowLevelGroup());
            this.serverBootstrap.channel(NettyAllocator.getServerChannelType());
            this.serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
            this.serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
            this.serverBootstrap.childHandler(this.configureServerChannelHandler());
            this.serverBootstrap.handler((ChannelHandler)new ServerChannelExceptionHandler(this));
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(this.settings)));
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)));
            if (((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)).booleanValue() && (IOUtils.LINUX || IOUtils.MAC_OS_X)) {
                SocketOption keepCountOption;
                SocketOption keepIntervalOption;
                SocketOption keepIdleOption;
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings) >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIdleOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings)));
                }
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings) >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIntervalOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings)));
                }
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings) >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepCountOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings)));
                }
            }
            if ((tcpSendBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
            }
            if ((tcpReceiveBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
            }
            this.serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            this.serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            boolean reuseAddress = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.bindServer();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws Exception {
        ChannelFuture future = this.serverBootstrap.bind((SocketAddress)socketAddress).sync();
        Channel channel = future.channel();
        Netty4HttpServerChannel httpServerChannel = new Netty4HttpServerChannel(channel);
        channel.attr(HTTP_SERVER_CHANNEL_KEY).set((Object)httpServerChannel);
        return httpServerChannel;
    }

    protected void stopInternal() {
        if (this.sharedGroup != null) {
            this.sharedGroup.shutdown();
            this.sharedGroup = null;
        }
    }

    public void onException(HttpChannel channel, Exception cause) {
        if (cause instanceof ReadTimeoutException) {
            super.onException(channel, (Exception)new HttpReadTimeoutException((long)this.readTimeoutMillis, cause));
        } else {
            super.onException(channel, cause);
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpChannelHandler(this, this.handlingSettings);
    }

    protected ChannelInboundHandlerAdapter createHeaderVerifier() {
        return new ChannelInboundHandlerAdapter();
    }

    protected ChannelInboundHandlerAdapter createDecompressor() {
        return new HttpContentDecompressor();
    }

    @ChannelHandler.Sharable
    private static class ServerChannelExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private final Netty4HttpServerTransport transport;

        private ServerChannelExceptionHandler(Netty4HttpServerTransport transport) {
            this.transport = transport;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            Netty4HttpServerChannel httpServerChannel = (Netty4HttpServerChannel)ctx.channel().attr(HTTP_SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                this.transport.onServerException(httpServerChannel, new Exception(cause));
            } else {
                this.transport.onServerException(httpServerChannel, (Exception)cause);
            }
        }
    }

    protected static class HttpChannelHandler
    extends ChannelInitializer<Channel> {
        private final Netty4HttpServerTransport transport;
        private final NettyByteBufSizer byteBufSizer;
        private final Netty4HttpRequestCreator requestCreator;
        private final Netty4HttpRequestHandler requestHandler;
        private final Netty4HttpResponseCreator responseCreator;
        private final HttpHandlingSettings handlingSettings;

        protected HttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings) {
            this.transport = transport;
            this.handlingSettings = handlingSettings;
            this.byteBufSizer = new NettyByteBufSizer();
            this.requestCreator = new Netty4HttpRequestCreator();
            this.requestHandler = new Netty4HttpRequestHandler(transport);
            this.responseCreator = new Netty4HttpResponseCreator();
        }

        public ChannelHandler getRequestHandler() {
            return this.requestHandler;
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4HttpChannel nettyHttpChannel = new Netty4HttpChannel(ch);
            ch.attr(HTTP_CHANNEL_KEY).set((Object)nettyHttpChannel);
            ch.pipeline().addLast("byte_buf_sizer", (ChannelHandler)this.byteBufSizer);
            ch.pipeline().addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler((long)this.transport.readTimeoutMillis, TimeUnit.MILLISECONDS));
            this.configurePipeline(ch);
            this.transport.serverAcceptedChannel(nettyHttpChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }

        protected void configurePipeline(final Channel ch) {
            HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

                public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                    if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                        return new Http2ServerUpgradeCodec(Http2FrameCodecBuilder.forServer().build(), new ChannelHandler[]{new Http2MultiplexHandler(this.createHttp2ChannelInitializer(ch.pipeline()))});
                    }
                    return null;
                }
            };
            HttpServerCodec sourceCodec = new HttpServerCodec(this.handlingSettings.getMaxInitialLineLength(), this.handlingSettings.getMaxHeaderSize(), this.handlingSettings.getMaxChunkSize());
            HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory, this.handlingSettings.getMaxContentLength());
            CleartextHttp2ServerUpgradeHandler cleartextUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, this.createHttp2ChannelInitializerPriorKnowledge());
            ch.pipeline().addLast(new ChannelHandler[]{cleartextUpgradeHandler}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(){

                protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                    HttpObjectAggregator aggregator = new HttpObjectAggregator(handlingSettings.getMaxContentLength());
                    aggregator.setMaxCumulationBufferComponents(transport.maxCompositeBufferComponents);
                    ChannelPipeline pipeline = ctx.pipeline();
                    pipeline.addAfter(ctx.name(), "handler", this.getRequestHandler());
                    pipeline.replace((ChannelHandler)this, "header_verifier", (ChannelHandler)transport.createHeaderVerifier());
                    pipeline.addAfter("header_verifier", "decoder_compress", (ChannelHandler)transport.createDecompressor());
                    pipeline.addAfter("decoder_compress", "aggregator", (ChannelHandler)aggregator);
                    if (handlingSettings.isCompression()) {
                        pipeline.addAfter("aggregator", "encoder_compress", (ChannelHandler)new HttpContentCompressor(handlingSettings.getCompressionLevel()));
                    }
                    pipeline.addBefore("handler", "request_creator", (ChannelHandler)requestCreator);
                    pipeline.addBefore("handler", "response_creator", (ChannelHandler)responseCreator);
                    pipeline.addBefore("handler", "pipelining", (ChannelHandler)new Netty4HttpPipeliningHandler(logger, transport.pipeliningMaxEvents));
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                }
            }});
        }

        protected void configureDefaultHttpPipeline(ChannelPipeline pipeline) {
            HttpRequestDecoder decoder = new HttpRequestDecoder(this.handlingSettings.getMaxInitialLineLength(), this.handlingSettings.getMaxHeaderSize(), this.handlingSettings.getMaxChunkSize());
            decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            pipeline.addLast("decoder", (ChannelHandler)decoder);
            pipeline.addLast("header_verifier", (ChannelHandler)this.transport.createHeaderVerifier());
            pipeline.addLast("decoder_compress", (ChannelHandler)this.transport.createDecompressor());
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            HttpObjectAggregator aggregator = new HttpObjectAggregator(this.handlingSettings.getMaxContentLength());
            aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            pipeline.addLast("aggregator", (ChannelHandler)aggregator);
            if (this.handlingSettings.isCompression()) {
                pipeline.addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.handlingSettings.getCompressionLevel()));
            }
            pipeline.addLast("request_creator", (ChannelHandler)this.requestCreator);
            pipeline.addLast("response_creator", (ChannelHandler)this.responseCreator);
            pipeline.addLast("pipelining", (ChannelHandler)new Netty4HttpPipeliningHandler(logger, this.transport.pipeliningMaxEvents));
            pipeline.addLast("handler", (ChannelHandler)this.requestHandler);
        }

        protected void configureDefaultHttp2Pipeline(ChannelPipeline pipeline) {
            pipeline.addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build()}).addLast(new ChannelHandler[]{new Http2MultiplexHandler(this.createHttp2ChannelInitializer(pipeline))});
        }

        private ChannelInitializer<Channel> createHttp2ChannelInitializerPriorKnowledge() {
            return new ChannelInitializer<Channel>(){

                protected void initChannel(Channel childChannel) throws Exception {
                    this.configureDefaultHttp2Pipeline(childChannel.pipeline());
                }
            };
        }

        private ChannelInitializer<Channel> createHttp2ChannelInitializer(final ChannelPipeline inboundPipeline) {
            return new ChannelInitializer<Channel>(){

                protected void initChannel(Channel childChannel) throws Exception {
                    Netty4HttpChannel nettyHttpChannel = new Netty4HttpChannel(childChannel, inboundPipeline);
                    childChannel.attr(HTTP_CHANNEL_KEY).set((Object)nettyHttpChannel);
                    HttpObjectAggregator aggregator = new HttpObjectAggregator(handlingSettings.getMaxContentLength());
                    aggregator.setMaxCumulationBufferComponents(transport.maxCompositeBufferComponents);
                    childChannel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)}).addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)}).addLast("byte_buf_sizer", (ChannelHandler)byteBufSizer).addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler((long)transport.readTimeoutMillis, TimeUnit.MILLISECONDS)).addLast("header_verifier", (ChannelHandler)transport.createHeaderVerifier()).addLast("decoder_decompress", (ChannelHandler)transport.createDecompressor());
                    if (handlingSettings.isCompression()) {
                        childChannel.pipeline().addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(handlingSettings.getCompressionLevel()));
                    }
                    childChannel.pipeline().addLast("aggregator", (ChannelHandler)aggregator).addLast("request_creator", (ChannelHandler)requestCreator).addLast("response_creator", (ChannelHandler)responseCreator).addLast("pipelining", (ChannelHandler)new Netty4HttpPipeliningHandler(logger, transport.pipeliningMaxEvents)).addLast("handler", this.getRequestHandler());
                }
            };
        }
    }
}

