/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.transport.netty4;

import io.lucenia.transport.netty4.Netty4TcpChannel;
import io.lucenia.transport.netty4.Netty4Transport;
import io.lucenia.transport.netty4.Netty4Utils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.bytes.ReleasableBytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.util.PageCacheRecycler;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.InboundPipeline;
import io.skylite.core.transport.TcpChannel;
import io.skylite.core.transport.Transport;
import io.skylite.core.transport.Transports;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

final class Netty4MessageChannelHandler
extends ChannelDuplexHandler {
    private final Netty4Transport transport;
    private final Queue<WriteOperation> queuedWrites = new ArrayDeque<WriteOperation>();
    private WriteOperation currentWrite;
    private final InboundPipeline pipeline;

    Netty4MessageChannelHandler(PageCacheRecycler recycler, Netty4Transport transport) {
        this.transport = transport;
        ThreadPool threadPool = transport.getThreadPool();
        Transport.RequestHandlers requestHandlers = transport.getRequestHandlers();
        this.pipeline = new InboundPipeline(transport.getVersion(), transport.getStatsTracker(), recycler, () -> ((ThreadPool)threadPool).relativeTimeInMillis(), transport.getInflightBreaker(), arg_0 -> ((Transport.RequestHandlers)requestHandlers).getHandler(arg_0), (arg_0, arg_1) -> ((Netty4Transport)transport).inboundMessage(arg_0, arg_1));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        assert (Transports.assertTransportThread());
        assert (msg instanceof ByteBuf) : "Expected message type ByteBuf, found: " + String.valueOf(msg.getClass());
        ByteBuf buffer = (ByteBuf)msg;
        Netty4TcpChannel channel = (Netty4TcpChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        BytesReference wrapped = Netty4Utils.toBytesReference(buffer);
        try (ReleasableBytesReference reference = new ReleasableBytesReference(wrapped, () -> ((ByteBuf)buffer).release());){
            this.pipeline.handleBytes((TcpChannel)channel, reference);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        SkyliteExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        Throwable unwrapped = SkyliteExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{SkyliteException.class});
        Throwable newCause = unwrapped != null ? unwrapped : cause;
        Netty4TcpChannel tcpChannel = (Netty4TcpChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        if (newCause instanceof Error) {
            this.transport.onException(tcpChannel, new Exception(newCause));
        } else {
            this.transport.onException(tcpChannel, (Exception)newCause);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof ByteBuf);
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        boolean queued = this.queuedWrites.offer(new WriteOperation((ByteBuf)msg, promise));
        assert (queued);
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    public void flush(ChannelHandlerContext ctx) {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        Channel channel = ctx.channel();
        if (channel.isWritable() || !channel.isActive()) {
            this.doFlush(ctx);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.transport.getThreadPool().getThreadContext()));
        this.doFlush(ctx);
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.pipeline});
        super.channelInactive(ctx);
    }

    private void doFlush(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            if (this.currentWrite != null) {
                this.currentWrite.promise.tryFailure((Throwable)new ClosedChannelException());
            }
            this.failQueuedWrites();
            return;
        }
        while (channel.isWritable()) {
            ByteBuf writeBuffer;
            boolean sliced;
            if (this.currentWrite == null) {
                this.currentWrite = this.queuedWrites.poll();
            }
            if (this.currentWrite == null) break;
            WriteOperation write = this.currentWrite;
            if (write.buf.readableBytes() == 0) {
                write.promise.trySuccess();
                this.currentWrite = null;
                continue;
            }
            int readableBytes = write.buf.readableBytes();
            int bufferSize = Math.min(readableBytes, 262144);
            int readerIndex = write.buf.readerIndex();
            boolean bl = sliced = readableBytes != bufferSize;
            if (sliced) {
                writeBuffer = write.buf.retainedSlice(readerIndex, bufferSize);
                write.buf.readerIndex(readerIndex + bufferSize);
            } else {
                writeBuffer = write.buf;
            }
            ChannelFuture writeFuture = ctx.write((Object)writeBuffer);
            if (!sliced || write.buf.readableBytes() == 0) {
                this.currentWrite = null;
                writeFuture.addListener(future -> {
                    assert (ctx.executor().inEventLoop());
                    if (future.isSuccess()) {
                        write.promise.trySuccess();
                    } else {
                        write.promise.tryFailure(future.cause());
                    }
                });
            } else {
                writeFuture.addListener(future -> {
                    assert (ctx.executor().inEventLoop());
                    if (!future.isSuccess()) {
                        write.promise.tryFailure(future.cause());
                    }
                });
            }
            ctx.flush();
            if (channel.isActive()) continue;
            this.failQueuedWrites();
            return;
        }
    }

    private void failQueuedWrites() {
        WriteOperation queuedWrite;
        while ((queuedWrite = this.queuedWrites.poll()) != null) {
            queuedWrite.promise.tryFailure((Throwable)new ClosedChannelException());
        }
    }

    private static final class WriteOperation {
        private final ByteBuf buf;
        private final ChannelPromise promise;

        WriteOperation(ByteBuf buf, ChannelPromise promise) {
            this.buf = buf;
            this.promise = promise;
        }
    }
}

