/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.index.reindex.AbstractBaseReindexRestHandler;
import io.lucenia.index.reindex.RethrottleAction;
import io.lucenia.index.reindex.RethrottleRequest;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.tasks.TaskId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.admin.cluster.RestListTasksAction;

public class RestRethrottleAction
extends BaseRestHandler {
    private final Supplier<DiscoveryNodes> nodesInCluster;

    public RestRethrottleAction(Supplier<DiscoveryNodes> nodesInCluster) {
        this.nodesInCluster = nodesInCluster;
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_update_by_query/{taskId}/_rethrottle"), new RestHandler.Route(RestRequest.Method.POST, "/_delete_by_query/{taskId}/_rethrottle"), new RestHandler.Route(RestRequest.Method.POST, "/_reindex/{taskId}/_rethrottle")));
    }

    public String getName() {
        return "rethrottle_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        RethrottleRequest internalRequest = new RethrottleRequest();
        internalRequest.setTaskId(new TaskId(request.param("taskId")));
        Float requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(request);
        if (requestsPerSecond == null) {
            throw new IllegalArgumentException("requests_per_second is a required parameter");
        }
        internalRequest.setRequestsPerSecond(requestsPerSecond.floatValue());
        String groupBy = request.param("group_by", "nodes");
        return channel -> client.execute((ActionType)RethrottleAction.INSTANCE, (ActionRequest)internalRequest, RestListTasksAction.listTasksResponseListener(this.nodesInCluster, (String)groupBy, (RestChannel)channel));
    }
}

