/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.index.reindex.AbstractAsyncBulkByScrollAction;
import io.lucenia.index.reindex.BulkByScrollParallelizationHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.ParentTaskAssigningClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.ScrollableHitSource;
import org.opensearch.index.reindex.UpdateByQueryAction;
import org.opensearch.index.reindex.UpdateByQueryRequest;
import org.opensearch.index.reindex.WorkerBulkByScrollTaskState;

public class TransportUpdateByQueryAction
extends HandledTransportAction<UpdateByQueryRequest, BulkByScrollResponse> {
    private final ThreadPool threadPool;
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;

    @Inject
    public TransportUpdateByQueryAction(ThreadPool threadPool, ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService) {
        super("indices:data/write/update/byquery", transportService, actionFilters, UpdateByQueryRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        BulkByScrollParallelizationHelper.startSlicedAction(request, bulkByScrollTask, (ActionType<BulkByScrollResponse>)UpdateByQueryAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ClusterState state = this.clusterService.state();
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)bulkByScrollTask);
            new AsyncIndexBySearchAction(bulkByScrollTask, this.logger, assigningClient, this.threadPool, this.scriptService, request, state, listener).start();
        });
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<UpdateByQueryRequest, TransportUpdateByQueryAction> {
        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, ScriptService scriptService, UpdateByQueryRequest request, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
            super(task, false, true, logger, client, threadPool, request, listener, scriptService, null);
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((UpdateByQueryRequest)this.mainRequest).getScript();
            if (script != null) {
                return new UpdateByQueryScriptApplier(this, this.worker, this.scriptService, script, script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index = new IndexRequest();
            index.index(doc.getIndex());
            index.id(doc.getId());
            index.source(doc.getSource(), doc.getMediaType());
            index.setIfSeqNo(doc.getSeqNo());
            index.setIfPrimaryTerm(doc.getPrimaryTerm());
            index.setPipeline(((UpdateByQueryRequest)this.mainRequest).getPipeline());
            return AsyncIndexBySearchAction.wrap(index);
        }

        class UpdateByQueryScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier {
            UpdateByQueryScriptApplier(AsyncIndexBySearchAction this$0, WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(taskWorker, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_index] not allowed");
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [" + ParseField.CommonMetaFields.ID_FIELD.getPreferredName() + "] not allowed");
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [_version] not allowed");
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                throw new IllegalArgumentException("Modifying [" + String.valueOf(ParseField.CommonMetaFields.ROUTING_FIELD) + "] not allowed");
            }
        }
    }
}

