/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex.remote;

import io.lucenia.client.Request;
import io.lucenia.client.Response;
import io.lucenia.client.ResponseException;
import io.lucenia.client.ResponseListener;
import io.lucenia.client.RestClient;
import io.lucenia.index.reindex.remote.RemoteRequestBuilders;
import io.lucenia.index.reindex.remote.RemoteResponseParsers;
import io.skylite.SkyliteException;
import io.skylite.SkyliteStatusException;
import io.skylite.Version;
import io.skylite.common.Nullable;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParseException;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hc.core5.http.ContentTooLongException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.index.reindex.RejectAwareActionListener;
import org.opensearch.index.reindex.ScrollableHitSource;

public class RemoteScrollableHitSource
extends ScrollableHitSource {
    private final RestClient client;
    private final BytesReference query;
    private final SearchRequest searchRequest;
    public Version<?> remoteVersion;

    public RemoteScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<ScrollableHitSource.AsyncResponse> onResponse, Consumer<Exception> fail, RestClient client, BytesReference query, SearchRequest searchRequest) {
        super(logger, backoffPolicy, threadPool, countSearchRetry, onResponse, fail);
        this.query = query;
        this.searchRequest = searchRequest;
        this.client = client;
    }

    public void doStart(RejectAwareActionListener<ScrollableHitSource.Response> searchListener) {
        this.lookupRemoteVersion(RejectAwareActionListener.withResponseHandler(searchListener, version -> {
            this.remoteVersion = version;
            this.execute(RemoteRequestBuilders.initialSearch(this.searchRequest, this.query, this.remoteVersion), (BiFunction)RemoteResponseParsers.RESPONSE_PARSER, (RejectAwareActionListener)RejectAwareActionListener.withResponseHandler((RejectAwareActionListener)searchListener, r -> this.onStartResponse(searchListener, (ScrollableHitSource.Response)r)));
        }));
    }

    public void lookupRemoteVersion(RejectAwareActionListener<Version<? extends Version<?>>> listener) {
        this.execute(new Request("GET", ""), (p, m) -> {
            try {
                return (Version)RemoteResponseParsers.MAIN_ACTION_PARSER.parse(p, m);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, listener);
    }

    private void onStartResponse(RejectAwareActionListener<ScrollableHitSource.Response> searchListener, ScrollableHitSource.Response response) {
        if (Strings.hasLength((String)response.getScrollId()) && response.getHits().isEmpty()) {
            this.logger.debug("First response looks like a scan response. Jumping right to the second. scroll=[{}]", (Object)response.getScrollId());
            this.doStartNextScroll(response.getScrollId(), TimeValue.timeValueMillis((long)0L), searchListener);
        } else {
            searchListener.onResponse((Object)response);
        }
    }

    public void doStartNextScroll(String scrollId, TimeValue extraKeepAlive, RejectAwareActionListener<ScrollableHitSource.Response> searchListener) {
        TimeValue keepAlive = TimeValue.timeValueNanos((long)(this.searchRequest.scroll().keepAlive().nanos() + extraKeepAlive.nanos()));
        this.execute(RemoteRequestBuilders.scroll(scrollId, keepAlive, this.remoteVersion), (BiFunction)RemoteResponseParsers.RESPONSE_PARSER, (RejectAwareActionListener)searchListener);
    }

    protected void clearScroll(final String scrollId, final Runnable onCompletion) {
        this.client.performRequestAsync(RemoteRequestBuilders.clearScroll(scrollId, this.remoteVersion), new ResponseListener(){

            public void onSuccess(Response response) {
                RemoteScrollableHitSource.this.logger.debug("Successfully cleared [{}]", (Object)scrollId);
                onCompletion.run();
            }

            public void onFailure(Exception e) {
                this.logFailure(e);
                onCompletion.run();
            }

            private void logFailure(Exception e) {
                if (e instanceof ResponseException) {
                    ResponseException re = (ResponseException)e;
                    if (RemoteScrollableHitSource.this.remoteVersion.before(Version.fromId((int)2000099)) && re.getResponse().getStatusLine().getStatusCode() == 404) {
                        RemoteScrollableHitSource.this.logger.debug(() -> new ParameterizedMessage("Failed to clear scroll [{}] from pre-2.0 OpenSearch. This is normal if the request terminated normally as the scroll has already been cleared automatically.", (Object)scrollId), (Throwable)e);
                        return;
                    }
                }
                RemoteScrollableHitSource.this.logger.warn(() -> new ParameterizedMessage("Failed to clear scroll [{}]", (Object)scrollId), (Throwable)e);
            }
        });
    }

    public void cleanup(Runnable onCompletion) {
        this.threadPool.generic().submit(() -> {
            try {
                this.client.close();
                this.logger.debug("Shut down remote connection");
            }
            catch (IOException e) {
                this.logger.error("Failed to shutdown the remote connection", (Throwable)e);
            }
            finally {
                onCompletion.run();
            }
        });
    }

    private <T> void execute(Request request, final BiFunction<XContentParser, MediaType, T> parser, final RejectAwareActionListener<? super T> listener) {
        final Supplier contextSupplier = this.threadPool.getThreadContext().newRestorableContext(true);
        try {
            this.client.performRequestAsync(request, new ResponseListener(){

                public void onSuccess(Response response) {
                    try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                        Object parsedResponse;
                        assert (ctx != null);
                        try {
                            HttpEntity responseEntity = response.getEntity();
                            InputStream content = responseEntity.getContent();
                            MediaType mediaType = null;
                            if (responseEntity.getContentType() != null) {
                                String mimeType = ContentType.parse((CharSequence)responseEntity.getContentType()).getMimeType();
                                mediaType = MediaType.fromMediaType((String)mimeType);
                            }
                            if (mediaType == null) {
                                try {
                                    RemoteScrollableHitSource.this.logger.debug("Response didn't include Content-Type: " + RemoteScrollableHitSource.bodyMessage(response.getEntity()));
                                    throw new SkyliteException("Response didn't include supported Content-Type, remote is likely not an OpenSearch instance", new Object[0]);
                                }
                                catch (IOException e) {
                                    SkyliteException ee = new SkyliteException("Error extracting body from response", new Object[0]);
                                    ee.addSuppressed((Throwable)e);
                                    throw ee;
                                }
                            }
                            try (XContentParser xContentParser = mediaType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, content);){
                                parsedResponse = parser.apply(xContentParser, mediaType);
                            }
                            catch (XContentParseException e) {
                                throw new SkyliteException("Error parsing the response, remote is likely not an OpenSearch instance", (Throwable)e, new Object[0]);
                            }
                        }
                        catch (IOException e) {
                            throw new SkyliteException("Error deserializing response, remote is likely not an OpenSearch instance", (Throwable)e, new Object[0]);
                        }
                        listener.onResponse(parsedResponse);
                    }
                }

                public void onFailure(Exception e) {
                    try (ThreadContext.StoredContext ctx = (ThreadContext.StoredContext)contextSupplier.get();){
                        assert (ctx != null);
                        if (e instanceof ResponseException) {
                            ResponseException re = (ResponseException)e;
                            int statusCode = re.getResponse().getStatusLine().getStatusCode();
                            e = RemoteScrollableHitSource.wrapExceptionToPreserveStatus(statusCode, re.getResponse().getEntity(), (Exception)re);
                            if (RestStatus.TOO_MANY_REQUESTS.getStatus() == statusCode) {
                                listener.onRejection(e);
                                return;
                            }
                        } else if (e instanceof ContentTooLongException) {
                            e = new IllegalArgumentException("Remote responded with a chunk that was too large. Use a smaller batch size.", e);
                        }
                        listener.onFailure(e);
                    }
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public static SkyliteStatusException wrapExceptionToPreserveStatus(int statusCode, @Nullable HttpEntity entity, Exception cause) {
        RestStatus status = RestStatus.fromCode((int)statusCode);
        Object messagePrefix = "";
        if (status == null) {
            messagePrefix = "Couldn't extract status [" + statusCode + "]. ";
            status = RestStatus.INTERNAL_SERVER_ERROR;
        }
        try {
            return new SkyliteStatusException((String)messagePrefix + RemoteScrollableHitSource.bodyMessage(entity), status, (Throwable)cause, new Object[0]);
        }
        catch (IOException ioe) {
            SkyliteStatusException e = new SkyliteStatusException((String)messagePrefix + "Failed to extract body.", status, (Throwable)cause, new Object[0]);
            e.addSuppressed((Throwable)ioe);
            return e;
        }
    }

    private static String bodyMessage(@Nullable HttpEntity entity) throws IOException {
        if (entity == null) {
            return "No error body.";
        }
        try {
            return "body=" + EntityUtils.toString((HttpEntity)entity);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }
}

