/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.join.aggregations;

import io.lucenia.join.aggregations.ChildrenToParentAggregator;
import io.lucenia.join.aggregations.ParentAggregatorFactory;
import io.lucenia.join.mapper.Joiner;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;

public class ParentAggregationBuilder
extends ValuesSourceAggregationBuilder<ParentAggregationBuilder> {
    public static final String NAME = "parent";
    private final String childType;
    private Query parentFilter;
    private Query childFilter;

    public ParentAggregationBuilder(String name, String childType) {
        super(name);
        if (childType == null) {
            throw new IllegalArgumentException("[childType] must not be null: [" + name + "]");
        }
        this.childType = childType;
    }

    protected ParentAggregationBuilder(ParentAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((ValuesSourceAggregationBuilder)clone, factoriesBuilder, metadata);
        this.childType = clone.childType;
        this.childFilter = clone.childFilter;
        this.parentFilter = clone.parentFilter;
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new ParentAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public ParentAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.childType = in.readString();
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.childType);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new ParentAggregatorFactory(this.name, config, this.childFilter, this.parentFilter, context, parent, subFactoriesBuilder, this.metadata);
    }

    protected ValuesSourceConfig resolveConfig(AggregationContext context) {
        ValuesSourceConfig config;
        Joiner joiner = Joiner.getJoiner(context);
        if (joiner != null && joiner.childTypeExists(this.childType)) {
            this.parentFilter = joiner.parentFilter(this.childType);
            this.childFilter = joiner.filter(this.childType);
            MappedFieldType fieldType = context.getFieldType(joiner.parentJoinField(this.childType));
            config = ValuesSourceConfig.resolveFieldOnly((MappedFieldType)fieldType, (AggregationContext)context);
        } else {
            config = ValuesSourceConfig.resolveUnmapped((ValuesSourceType)this.defaultValueSourceType(), (AggregationContext)context);
        }
        return config;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ChildrenToParentAggregator.TYPE_FIELD.getPreferredName(), this.childType);
        return builder;
    }

    public static ParentAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + String.valueOf(token) + " in [" + aggregationName + "].", new Object[0]);
        }
        if (childType == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing [child_type] field for parent aggregation [" + aggregationName + "]", new Object[0]);
        }
        return new ParentAggregationBuilder(aggregationName, childType);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.childType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ParentAggregationBuilder other = (ParentAggregationBuilder)((Object)obj);
        return Objects.equals(this.childType, other.childType);
    }

    public String getType() {
        return NAME;
    }

    protected AggregationRegistry.RegistryKey<?> getRegistryKey() {
        return AggregationRegistry.UNREGISTERED_KEY;
    }
}

