/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.join.query;

import io.lucenia.join.mapper.Joiner;
import io.lucenia.join.query.HasChildQueryBuilder;
import io.lucenia.join.query.ParentChildInnerHitContextBuilder;
import io.skylite.SkyliteException;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.InnerHitBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.search.SearchServiceSettings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.InnerHitContextBuilder;

public class HasParentQueryBuilder
extends AbstractQueryBuilder<HasParentQueryBuilder> {
    public static final String NAME = "has_parent";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField PARENT_TYPE_FIELD = new ParseField("parent_type", new String[0]);
    private static final ParseField SCORE_FIELD = new ParseField("score", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final QueryBuilder query;
    private final String parentType;
    private final boolean score;
    private InnerHitBuilder innerHitBuilder;
    private boolean ignoreUnmapped = false;

    public HasParentQueryBuilder(String parentType, QueryBuilder query, boolean score) {
        this(parentType, query, score, null);
    }

    private HasParentQueryBuilder(String parentType, QueryBuilder query, boolean score, InnerHitBuilder innerHitBuilder) {
        this.parentType = (String)HasParentQueryBuilder.requireValue((Object)parentType, (String)("[has_parent] requires '" + PARENT_TYPE_FIELD.getPreferredName() + "' field"));
        this.query = (QueryBuilder)HasParentQueryBuilder.requireValue((Object)query, (String)("[has_parent] requires '" + QUERY_FIELD.getPreferredName() + "' field"));
        this.score = score;
        this.innerHitBuilder = innerHitBuilder;
    }

    public HasParentQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.parentType = in.readString();
        this.score = in.readBoolean();
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = (InnerHitBuilder)in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.parentType);
        out.writeBoolean(this.score);
        out.writeNamedWriteable((NamedWriteable)this.query);
        out.writeOptionalWriteable((Writeable)this.innerHitBuilder);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public boolean score() {
        return this.score;
    }

    public String type() {
        return this.parentType;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public HasParentQueryBuilder innerHit(InnerHitBuilder innerHit) {
        this.innerHitBuilder = innerHit;
        this.innerHitBuilder.setIgnoreUnmapped(this.ignoreUnmapped);
        return this;
    }

    public HasParentQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        if (this.innerHitBuilder != null) {
            this.innerHitBuilder.setIgnoreUnmapped(ignoreUnmapped);
        }
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (!context.allowExpensiveQueries()) {
            throw new SkyliteException("[joining] queries cannot be executed when '" + SearchServiceSettings.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        Joiner joiner = Joiner.getJoiner(context);
        if (joiner == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context.getFullyQualifiedIndex(), "[has_parent] no join field has been configured", new Object[0]);
        }
        if (!joiner.parentTypeExists(this.parentType)) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException(context.getFullyQualifiedIndex(), "[has_parent] join field [" + joiner.getJoinField() + "] doesn't hold [" + this.parentType + "] as a parent", new Object[0]);
        }
        Query parentFilter = joiner.filter(this.parentType);
        BooleanQuery innerQuery = Queries.filtered((Query)this.query.toQuery((QueryRewriteContext)context), (Query)parentFilter);
        Query childFilter = joiner.childrenFilter(this.parentType);
        MappedFieldType fieldType = context.getFieldType(joiner.childJoinField(this.parentType));
        SortedSetOrdinalsIndexFieldData fieldData = (SortedSetOrdinalsIndexFieldData)context.getForField(fieldType);
        return new HasChildQueryBuilder.LateParsingQuery(childFilter, (Query)innerQuery, 1, Integer.MAX_VALUE, fieldType.name(), this.score ? ScoreMode.Max : ScoreMode.None, fieldData, context.getSearchSimilarity());
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(PARENT_TYPE_FIELD.getPreferredName(), this.parentType);
        builder.field(SCORE_FIELD.getPreferredName(), this.score);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), (ToXContent)this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static HasParentQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        String parentType = null;
        boolean score = false;
        String queryName = null;
        InnerHitBuilder innerHits = null;
        boolean ignoreUnmapped = false;
        String currentFieldName = null;
        QueryBuilder iqb = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    iqb = QueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    innerHits = InnerHitBuilder.fromXContent((XContentParser)parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (PARENT_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                parentType = parser.text();
                continue;
            }
            if (SCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                score = parser.booleanValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[has_parent] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        HasParentQueryBuilder queryBuilder = (HasParentQueryBuilder)((HasParentQueryBuilder)new HasParentQueryBuilder(parentType, iqb, score).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        if (innerHits != null) {
            queryBuilder.innerHit(innerHits);
        }
        return queryBuilder;
    }

    public String getWriteableName() {
        return NAME;
    }

    protected boolean doEquals(HasParentQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.parentType, that.parentType) && Objects.equals(this.score, that.score) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    protected int doHashCode() {
        return Objects.hash(this.query, this.parentType, this.score, this.innerHitBuilder, this.ignoreUnmapped);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryShardContext);
        if (rewrittenQuery != this.query) {
            HasParentQueryBuilder hasParentQueryBuilder = new HasParentQueryBuilder(this.parentType, rewrittenQuery, this.score, this.innerHitBuilder);
            hasParentQueryBuilder.ignoreUnmapped(this.ignoreUnmapped);
            return hasParentQueryBuilder;
        }
        return this;
    }

    public void extractInnerHitBuilders(AbstractQueryBuilder.InnerHitCollector<?> collector, AbstractQueryBuilder.InnerHitExtractor extractor) {
        if (this.innerHitBuilder != null) {
            InnerHitContextBuilder.MapBackedInnerHitCollector mapCollector;
            String name;
            String string = name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.parentType;
            if (collector instanceof InnerHitContextBuilder.MapBackedInnerHitCollector && (mapCollector = (InnerHitContextBuilder.MapBackedInnerHitCollector)collector).containsKey(name)) {
                throw new IllegalArgumentException("[inner_hits] already contains an entry for key [" + name + "]");
            }
            HashMap<String, InnerHitContextBuilder> children = new HashMap<String, InnerHitContextBuilder>();
            InnerHitContextBuilder.MapBackedInnerHitCollector childCollector = new InnerHitContextBuilder.MapBackedInnerHitCollector(children);
            extractor.extract(this.query, (AbstractQueryBuilder.InnerHitCollector)childCollector);
            ParentChildInnerHitContextBuilder innerHitContextBuilder = new ParentChildInnerHitContextBuilder(this.parentType, false, this.query, this.innerHitBuilder, children);
            AbstractQueryBuilder.InnerHitCollector<?> typedCollector = collector;
            typedCollector.add(name, (Object)innerHitContextBuilder);
        }
    }
}

