/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.script.expression;

import io.lucenia.script.expression.CountMethodValueSource;
import io.lucenia.script.expression.DateMethodValueSource;
import io.lucenia.script.expression.EmptyMemberValueSource;
import io.lucenia.script.expression.FieldDataValueSource;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.search.MultiValueMode;
import org.apache.lucene.search.DoubleValuesSource;

final class DateField {
    static final String VALUE_VARIABLE = "value";
    static final String EMPTY_VARIABLE = "empty";
    static final String LENGTH_VARIABLE = "length";
    static final String GETVALUE_METHOD = "getValue";
    static final String ISEMPTY_METHOD = "isEmpty";
    static final String SIZE_METHOD = "size";
    static final String MINIMUM_METHOD = "min";
    static final String MAXIMUM_METHOD = "max";
    static final String AVERAGE_METHOD = "avg";
    static final String MEDIAN_METHOD = "median";
    static final String SUM_METHOD = "sum";
    static final String COUNT_METHOD = "count";
    static final String GET_YEAR_METHOD = "getYear";
    static final String GET_MONTH_METHOD = "getMonth";
    static final String GET_DAY_OF_MONTH_METHOD = "getDayOfMonth";
    static final String GET_HOUR_OF_DAY_METHOD = "getHourOfDay";
    static final String GET_MINUTES_METHOD = "getMinutes";
    static final String GET_SECONDS_METHOD = "getSeconds";

    private DateField() {
    }

    static DoubleValuesSource getVariable(IndexFieldData<?> fieldData, String fieldName, String variable) {
        switch (variable) {
            case "value": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            }
            case "empty": {
                return new EmptyMemberValueSource(fieldData);
            }
            case "length": {
                return new CountMethodValueSource(fieldData);
            }
        }
        throw new IllegalArgumentException("Member variable [" + variable + "] does not exist for date field [" + fieldName + "].");
    }

    static DoubleValuesSource getMethod(IndexFieldData<?> fieldData, String fieldName, String method) {
        switch (method) {
            case "getValue": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            }
            case "isEmpty": {
                return new EmptyMemberValueSource(fieldData);
            }
            case "size": {
                return new CountMethodValueSource(fieldData);
            }
            case "min": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MIN);
            }
            case "max": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MAX);
            }
            case "avg": {
                return new FieldDataValueSource(fieldData, MultiValueMode.AVG);
            }
            case "median": {
                return new FieldDataValueSource(fieldData, MultiValueMode.MEDIAN);
            }
            case "sum": {
                return new FieldDataValueSource(fieldData, MultiValueMode.SUM);
            }
            case "count": {
                return new CountMethodValueSource(fieldData);
            }
            case "getYear": {
                return new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 1);
            }
            case "getMonth": {
                return new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 2);
            }
            case "getDayOfMonth": {
                return new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 5);
            }
            case "getHourOfDay": {
                return new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 11);
            }
            case "getMinutes": {
                return new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 12);
            }
            case "getSeconds": {
                return new DateMethodValueSource(fieldData, MultiValueMode.MIN, method, 13);
            }
        }
        throw new IllegalArgumentException("Member method [" + method + "] does not exist for date field [" + fieldName + "].");
    }
}

