/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.search.aggregations.support;

import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class ArrayValuesSourceAggregatorFactory
extends AggregatorFactory {
    protected Map<String, ValuesSourceConfig> configs;

    public ArrayValuesSourceAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, subFactoriesBuilder, metadata);
        this.configs = configs;
    }

    public Aggregator createInternal(SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        HashMap<String, ValuesSource> valuesSources = new HashMap<String, ValuesSource>();
        for (Map.Entry<String, ValuesSourceConfig> config : this.configs.entrySet()) {
            ValuesSourceConfig vsc = config.getValue();
            if (!vsc.hasValues()) continue;
            valuesSources.put(config.getKey(), vsc.getValuesSource());
        }
        if (valuesSources.isEmpty()) {
            return this.createUnmapped(searchContext, parent, metadata);
        }
        return this.doCreateInternal(valuesSources, searchContext, parent, cardinality, metadata);
    }

    protected abstract Aggregator createUnmapped(SearchExecutionContext var1, Aggregator var2, Map<String, Object> var3) throws IOException;

    protected abstract Aggregator doCreateInternal(Map<String, ValuesSource> var1, SearchExecutionContext var2, Aggregator var3, CardinalityUpperBound var4, Map<String, Object> var5) throws IOException;
}

