/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.common.xcontent;

import com.fasterxml.jackson.dataformat.cbor.CBORConstants;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.xcontent.cbor.CborXContent;
import io.skylite.common.xcontent.json.JsonXContent;
import io.skylite.common.xcontent.smile.SmileXContent;
import io.skylite.common.xcontent.yaml.YamlXContent;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;

public enum XContentType implements MediaType
{
    JSON(0){

        public String mediaTypeWithoutParameters() {
            return "application/json";
        }

        public String mediaType() {
            return "application/json; charset=UTF-8";
        }

        public String subtype() {
            return "json";
        }

        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }

        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            return bytes[offset] == 123;
        }

        public boolean detectedXContent(CharSequence content, int length) {
            return content.charAt(0) == '{';
        }

        public XContentBuilder contentBuilder() throws IOException {
            return JsonXContent.contentBuilder();
        }

        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder((XContent)JsonXContent.jsonXContent, os);
        }
    }
    ,
    SMILE(1){

        public String mediaTypeWithoutParameters() {
            return "application/smile";
        }

        public String subtype() {
            return "smile";
        }

        public XContent xContent() {
            return SmileXContent.smileXContent;
        }

        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            return length > 2 && bytes[offset] == 58 && bytes[offset + 1] == 41 && bytes[offset + 2] == 10;
        }

        public boolean detectedXContent(CharSequence content, int length) {
            return length > 2 && content.charAt(0) == ':' && content.charAt(1) == ')' && content.charAt(2) == '\n';
        }

        public XContentBuilder contentBuilder() throws IOException {
            return SmileXContent.contentBuilder();
        }

        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder((XContent)SmileXContent.smileXContent, os);
        }
    }
    ,
    YAML(2){

        public String mediaTypeWithoutParameters() {
            return "application/yaml";
        }

        public String subtype() {
            return "yaml";
        }

        public XContent xContent() {
            return YamlXContent.yamlXContent;
        }

        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            return length > 2 && bytes[offset] == 45 && bytes[offset + 1] == 45 && bytes[offset + 2] == 45;
        }

        public boolean detectedXContent(CharSequence content, int length) {
            return length > 2 && content.charAt(0) == '-' && content.charAt(1) == '-' && content.charAt(2) == '-';
        }

        public XContentBuilder contentBuilder() throws IOException {
            return YamlXContent.contentBuilder();
        }

        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder((XContent)YamlXContent.yamlXContent, os);
        }
    }
    ,
    CBOR(3){

        public String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        public String subtype() {
            return "cbor";
        }

        public XContent xContent() {
            return CborXContent.cborXContent;
        }

        public boolean detectedXContent(byte[] bytes, int offset, int length) {
            if (bytes[offset] == -65 && length > 1) {
                return true;
            }
            if (CBORConstants.hasMajorType((int)6, (byte)bytes[offset]) && length > 2 && bytes[offset] == -39 && bytes[offset + 1] == -39 && bytes[offset + 2] == -9) {
                return true;
            }
            return CBORConstants.hasMajorType((int)5, (byte)bytes[offset]);
        }

        public boolean detectedXContent(CharSequence content, int length) {
            return false;
        }

        public XContentBuilder contentBuilder() throws IOException {
            return CborXContent.contentBuilder();
        }

        public XContentBuilder contentBuilder(OutputStream os) throws IOException {
            return new XContentBuilder((XContent)CborXContent.cborXContent, os);
        }
    };

    private int index;

    private XContentType(int index) {
        this.index = index;
    }

    public static XContentType fromSubtype(String subtype) {
        return Arrays.stream(XContentType.values()).filter(type -> Objects.equals(type.subtype(), subtype)).findFirst().orElseThrow(() -> new NoSuchElementException("No such element matching subtype [" + subtype + "]"));
    }

    public int index() {
        return this.index;
    }

    public String type() {
        return "application";
    }

    public String format() {
        return this.subtype();
    }

    public void writeTo(StreamOutput output) throws IOException {
        if (output.getVersion().before((Version)OpenSearchVersion.V_2_10_0)) {
            output.writeVInt(this.ordinal());
        } else {
            output.writeString(this.mediaType());
        }
    }
}

