/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.CharArraySet;

public abstract class AbstractCompoundWordTokenFilterFactory
extends AbstractTokenFilterFactory {
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    protected final CharArraySet wordList;
    protected final boolean reuseChars;

    protected AbstractCompoundWordTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.minWordSize = settings.getAsInt("min_word_size", Integer.valueOf(5));
        this.minSubwordSize = settings.getAsInt("min_subword_size", Integer.valueOf(2));
        this.maxSubwordSize = settings.getAsInt("max_subword_size", Integer.valueOf(15));
        this.onlyLongestMatch = settings.getAsBoolean("only_longest_match", Boolean.valueOf(false));
        this.reuseChars = true;
        this.wordList = Analysis.getWordSet((Environment)env, (Settings)settings, (String)"word_list");
        if (this.wordList == null) {
            throw new IllegalArgumentException("word_list must be provided for [" + name + "], either as a path to a file, or directly");
        }
    }

    public TokenFilterFactory getSynonymFilter() {
        return IDENTITY_FILTER;
    }
}

