/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.script.ScriptContext;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public abstract class AnalysisPredicateScript {
    public static final String[] PARAMETERS = new String[]{"token"};
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext("analysis", Factory.class);

    public abstract boolean execute(Token var1);

    public static interface Factory {
        public AnalysisPredicateScript newInstance();
    }

    public static class Token {
        private final CharTermAttribute termAtt;
        private final PositionIncrementAttribute posIncAtt;
        private final PositionLengthAttribute posLenAtt;
        private final OffsetAttribute offsetAtt;
        private final TypeAttribute typeAtt;
        private final KeywordAttribute keywordAtt;
        private int pos = -1;

        public Token(AttributeSource source) {
            this.termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
            this.posIncAtt = (PositionIncrementAttribute)source.addAttribute(PositionIncrementAttribute.class);
            this.posLenAtt = (PositionLengthAttribute)source.addAttribute(PositionLengthAttribute.class);
            this.offsetAtt = (OffsetAttribute)source.addAttribute(OffsetAttribute.class);
            this.typeAtt = (TypeAttribute)source.addAttribute(TypeAttribute.class);
            this.keywordAtt = (KeywordAttribute)source.addAttribute(KeywordAttribute.class);
        }

        public void reset() {
            this.pos = -1;
        }

        public void updatePosition() {
            this.pos += this.posIncAtt.getPositionIncrement();
        }

        public CharSequence getTerm() {
            return this.termAtt;
        }

        public int getPositionIncrement() {
            return this.posIncAtt.getPositionIncrement();
        }

        public int getPosition() {
            return this.pos;
        }

        public int getPositionLength() {
            return this.posLenAtt.getPositionLength();
        }

        public int getStartOffset() {
            return this.offsetAtt.startOffset();
        }

        public int getEndOffset() {
            return this.offsetAtt.endOffset();
        }

        public String getType() {
            return this.typeAtt.type();
        }

        public boolean isKeyword() {
            return this.keywordAtt.isKeyword();
        }
    }
}

