/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.FloatEncoder;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.payloads.IntegerEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;

public class DelimitedPayloadTokenFilterFactory
extends AbstractTokenFilterFactory {
    public static final char DEFAULT_DELIMITER = '|';
    public static final PayloadEncoder DEFAULT_ENCODER = new FloatEncoder();
    static final String ENCODING = "encoding";
    static final String DELIMITER = "delimiter";
    private final char delimiter;
    private final PayloadEncoder encoder;

    DelimitedPayloadTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        String delimiterConf = settings.get(DELIMITER);
        this.delimiter = delimiterConf != null ? delimiterConf.charAt(0) : (char)124;
        this.encoder = settings.get(ENCODING) != null ? (settings.get(ENCODING).equals("float") ? new FloatEncoder() : (settings.get(ENCODING).equals("int") ? new IntegerEncoder() : (settings.get(ENCODING).equals("identity") ? new IdentityEncoder() : DEFAULT_ENCODER))) : DEFAULT_ENCODER;
    }

    public TokenStream create(TokenStream tokenStream) {
        return new DelimitedPayloadTokenFilter(tokenStream, this.delimiter, this.encoder);
    }
}

