/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.tartarus.snowball.SnowballStemmer;
import org.tartarus.snowball.ext.DutchStemmer;

public class DutchStemTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet exclusions;

    DutchStemTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.exclusions = Analysis.parseStemExclusion((Settings)settings, (CharArraySet)CharArraySet.EMPTY_SET);
    }

    public TokenStream create(TokenStream tokenStream) {
        tokenStream = new SetKeywordMarkerFilter(tokenStream, this.exclusions);
        return new SnowballFilter(tokenStream, (SnowballStemmer)new DutchStemmer());
    }
}

