/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.lucenia.analysis.common.CharMatcher;
import io.lucenia.analysis.common.NGramTokenizerFactory;
import io.skylite.core.analysis.AbstractTokenizerFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;

public class EdgeNGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final CharMatcher matcher;

    EdgeNGramTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        this.minGram = settings.getAsInt("min_gram", Integer.valueOf(1));
        this.maxGram = settings.getAsInt("max_gram", Integer.valueOf(2));
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings);
    }

    public Tokenizer create() {
        if (this.matcher == null) {
            return new EdgeNGramTokenizer(this.minGram, this.maxGram);
        }
        return new EdgeNGramTokenizer(this.minGram, this.maxGram){

            protected boolean isTokenChar(int chr) {
                return EdgeNGramTokenizerFactory.this.matcher.isTokenChar(chr);
            }
        };
    }
}

