/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.analysis.NormalizingTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.ElisionFilter;

public class ElisionTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private final CharArraySet articles;

    ElisionTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.articles = Analysis.parseArticles((Environment)env, (Settings)settings);
        if (this.articles == null) {
            throw new IllegalArgumentException("elision filter requires [articles] or [articles_path] setting");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ElisionFilter(tokenStream, this.articles);
    }
}

