/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.FingerprintFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public final class FingerprintAnalyzer
extends Analyzer {
    private final char separator;
    private final int maxOutputSize;
    private final CharArraySet stopWords;

    FingerprintAnalyzer(CharArraySet stopWords, char separator, int maxOutputSize) {
        this.separator = separator;
        this.maxOutputSize = maxOutputSize;
        this.stopWords = stopWords;
    }

    protected Analyzer.TokenStreamComponents createComponents(String s) {
        StandardTokenizer tokenizer;
        StandardTokenizer stream = tokenizer = new StandardTokenizer();
        stream = new LowerCaseFilter((TokenStream)stream);
        stream = new ASCIIFoldingFilter((TokenStream)stream, false);
        stream = new StopFilter((TokenStream)stream, this.stopWords);
        stream = new FingerprintFilter((TokenStream)stream, this.maxOutputSize, this.separator);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }
}

