/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.lucenia.analysis.common.FingerprintAnalyzerProvider;
import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.FingerprintFilter;

public class FingerprintTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final char separator;
    private final int maxOutputSize;

    FingerprintTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.separator = FingerprintAnalyzerProvider.parseSeparator(settings);
        this.maxOutputSize = settings.getAsInt(FingerprintAnalyzerProvider.MAX_OUTPUT_SIZE.getPreferredName(), Integer.valueOf(FingerprintAnalyzerProvider.DEFAULT_MAX_OUTPUT_SIZE));
    }

    public TokenStream create(TokenStream tokenStream) {
        TokenStream result = tokenStream;
        result = new FingerprintFilter(result, this.maxOutputSize, this.separator);
        return result;
    }

    public TokenFilterFactory getSynonymFilter() {
        throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
    }
}

