/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.common.util.set.Sets;
import io.skylite.core.analysis.AbstractCharFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;

public class HtmlStripCharFilterFactory
extends AbstractCharFilterFactory {
    private final Set<String> escapedTags;

    HtmlStripCharFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name);
        List escapedTags = settings.getAsList("escaped_tags");
        this.escapedTags = escapedTags.size() > 0 ? Collections.unmodifiableSet(Sets.newHashSet((Iterable)escapedTags)) : null;
    }

    public Reader create(Reader tokenStream) {
        return new HTMLStripCharFilter(tokenStream, this.escapedTags);
    }
}

