/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.util.List;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeepWordFilter;

public class KeepWordFilterFactory
extends AbstractTokenFilterFactory {
    private final CharArraySet keepWords;
    private static final String KEEP_WORDS_KEY = "keep_words";
    private static final String KEEP_WORDS_PATH_KEY = "keep_words_path";
    private static final String KEEP_WORDS_CASE_KEY = "keep_words_case";
    private static final String ENABLE_POS_INC_KEY = "enable_position_increments";

    KeepWordFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        List arrayKeepWords = settings.getAsList(KEEP_WORDS_KEY, null);
        String keepWordsPath = settings.get(KEEP_WORDS_PATH_KEY, null);
        if (arrayKeepWords == null && keepWordsPath == null || arrayKeepWords != null && keepWordsPath != null) {
            throw new IllegalArgumentException("keep requires either `keep_words` or `keep_words_path` to be configured");
        }
        if (settings.get(ENABLE_POS_INC_KEY) != null) {
            throw new IllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain");
        }
        this.keepWords = Analysis.getWordSet((Environment)env, (Settings)settings, (String)KEEP_WORDS_KEY);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new KeepWordFilter(tokenStream, this.keepWords);
    }
}

