/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountFilter;

public class LimitTokenCountFilterFactory
extends AbstractTokenFilterFactory {
    static final int DEFAULT_MAX_TOKEN_COUNT = 1;
    static final boolean DEFAULT_CONSUME_ALL_TOKENS = false;
    private final int maxTokenCount;
    private final boolean consumeAllTokens;

    LimitTokenCountFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.maxTokenCount = settings.getAsInt("max_token_count", Integer.valueOf(1));
        this.consumeAllTokens = settings.getAsBoolean("consume_all_tokens", Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new LimitTokenCountFilter(tokenStream, this.maxTokenCount, this.consumeAllTokens);
    }
}

