/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.analysis.NormalizingTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.ga.IrishLowerCaseFilter;
import org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;

public class LowerCaseTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private final String lang;

    LowerCaseTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.lang = settings.get("language", null);
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.lang == null) {
            return new LowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("greek")) {
            return new GreekLowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("irish")) {
            return new IrishLowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("turkish")) {
            return new TurkishLowerCaseFilter(tokenStream);
        }
        throw new IllegalArgumentException("language [" + this.lang + "] not support for lower case");
    }
}

