/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;

public class LuceniaSolrSynonymParser
extends SolrSynonymParser {
    private static final Logger logger = LogManager.getLogger(LuceniaSolrSynonymParser.class);
    private final boolean lenient;

    public LuceniaSolrSynonymParser(boolean dedup, boolean expand, boolean lenient, Analyzer analyzer) {
        super(dedup, expand, analyzer);
        this.lenient = lenient;
    }

    public void add(CharsRef input, CharsRef output, boolean includeOrig) {
        if (!this.lenient || input.length > 0 && output.length > 0) {
            super.add(input, output, includeOrig);
        }
    }

    public CharsRef analyze(String text, CharsRefBuilder reuse) throws IOException {
        try {
            return super.analyze(text, reuse);
        }
        catch (IllegalArgumentException ex) {
            if (this.lenient) {
                logger.info("Synonym rule for [" + text + "] was ignored");
                return new CharsRef("");
            }
            throw ex;
        }
    }
}

