/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenFilterFactory;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.pattern.PatternCaptureGroupTokenFilter;

public class PatternCaptureGroupTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Pattern[] patterns;
    private final boolean preserveOriginal;
    private static final String PATTERNS_KEY = "patterns";
    private static final String PRESERVE_ORIG_KEY = "preserve_original";

    PatternCaptureGroupTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        List regexes = settings.getAsList(PATTERNS_KEY, null, Boolean.valueOf(false));
        if (regexes == null) {
            throw new IllegalArgumentException("required setting 'patterns' is missing for token filter [" + name + "]");
        }
        this.patterns = new Pattern[regexes.size()];
        for (int i = 0; i < regexes.size(); ++i) {
            this.patterns[i] = Pattern.compile((String)regexes.get(i));
        }
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIG_KEY, Boolean.valueOf(true));
    }

    public TokenFilter create(TokenStream tokenStream) {
        return new PatternCaptureGroupTokenFilter(tokenStream, this.preserveOriginal, this.patterns);
    }
}

