/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.skylite.core.analysis.AbstractTokenizerFactory;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.settings.Settings;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;

public class PatternTokenizerFactory
extends AbstractTokenizerFactory {
    private final Pattern pattern;
    private final int group;

    PatternTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings, name);
        String sPattern = settings.get("pattern", "\\W+");
        if (sPattern == null) {
            throw new IllegalArgumentException("pattern is missing for [" + name + "] tokenizer of type 'pattern'");
        }
        this.pattern = Regex.compile((String)sPattern, (String)settings.get("flags"));
        this.group = settings.getAsInt("group", Integer.valueOf(-1));
    }

    public Tokenizer create() {
        return new PatternTokenizer(this.pattern, this.group);
    }
}

