/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.analysis.common;

import io.lucenia.analysis.common.LegacyRomanianStemmer;
import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.core.analysis.Analysis;
import io.skylite.core.env.Environment;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.AbstractIndexAnalyzerProvider;
import io.skylite.core.settings.Settings;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.tartarus.snowball.SnowballStemmer;

public class RomanianAnalyzerProvider
extends AbstractIndexAnalyzerProvider<StopwordAnalyzerBase> {
    private final StopwordAnalyzerBase analyzer;

    RomanianAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        CharArraySet stopwords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)RomanianAnalyzer.getDefaultStopSet());
        final CharArraySet stemExclusionSet = Analysis.parseStemExclusion((Settings)settings, (CharArraySet)CharArraySet.EMPTY_SET);
        this.analyzer = indexSettings.getIndexVersionCreated().onOrAfter((Version)LuceniaVersion.V_0_2_0) ? new RomanianAnalyzer(stopwords, stemExclusionSet) : new StopwordAnalyzerBase(this, Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)RomanianAnalyzer.getDefaultStopSet())){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer source = new StandardTokenizer();
                LowerCaseFilter result = new LowerCaseFilter((TokenStream)source);
                result = new StopFilter((TokenStream)result, this.stopwords);
                if (!stemExclusionSet.isEmpty()) {
                    result = new SetKeywordMarkerFilter((TokenStream)result, stemExclusionSet);
                }
                result = new SnowballFilter((TokenStream)result, (SnowballStemmer)new LegacyRomanianStemmer());
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
            }

            protected TokenStream normalize(String fieldName, TokenStream in) {
                return new LowerCaseFilter(in);
            }
        };
    }

    public StopwordAnalyzerBase get() {
        return this.analyzer;
    }
}

