/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.reindex;

import io.lucenia.action.support.AutoCreateIndex;
import io.lucenia.index.reindex.TransportReindexAction;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.Strings;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.settings.Settings;
import java.util.List;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.index.reindex.RemoteInfo;

class ReindexValidator {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ReindexValidator.class);
    static final String SORT_DEPRECATED_MESSAGE = "The sort option in reindex is deprecated. Instead consider using query filtering to find the desired subset of data.";
    private final CharacterRunAutomaton remoteAllowlist;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver resolver;
    private final AutoCreateIndex autoCreateIndex;

    ReindexValidator(Settings settings, ClusterService clusterService, IndexNameExpressionResolver resolver, AutoCreateIndex autoCreateIndex) {
        this.remoteAllowlist = ReindexValidator.buildRemoteAllowlist((List)TransportReindexAction.REMOTE_CLUSTER_ALLOWLIST.get(settings));
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.autoCreateIndex = autoCreateIndex;
    }

    void initialValidation(ReindexRequest request) {
        ReindexValidator.checkRemoteAllowlist(this.remoteAllowlist, request.getRemoteInfo());
        ClusterState state = this.clusterService.state();
        ReindexValidator.validateAgainstAliases(request.getSearchRequest(), request.getDestination(), request.getRemoteInfo(), this.resolver, this.autoCreateIndex, state);
        SearchSourceBuilder searchSource = request.getSearchRequest().source();
        if (searchSource != null && searchSource.sorts() != null && !searchSource.sorts().isEmpty()) {
            deprecationLogger.deprecate("reindex_sort", SORT_DEPRECATED_MESSAGE, new Object[0]);
        }
    }

    static void checkRemoteAllowlist(CharacterRunAutomaton allowlist, RemoteInfo remoteInfo) {
        if (remoteInfo == null) {
            return;
        }
        String check = remoteInfo.getHost() + ":" + remoteInfo.getPort();
        if (allowlist.run(check)) {
            return;
        }
        String allowListKey = TransportReindexAction.REMOTE_CLUSTER_ALLOWLIST.getKey();
        throw new IllegalArgumentException("[" + check + "] not allowlisted in " + allowListKey);
    }

    static CharacterRunAutomaton buildRemoteAllowlist(List<String> allowlist) {
        if (allowlist.isEmpty()) {
            return new CharacterRunAutomaton(Automata.makeEmpty());
        }
        Automaton automaton = Regex.simpleMatchToAutomaton((String[])allowlist.toArray(Strings.EMPTY_ARRAY));
        if (Operations.isTotal((Automaton)(automaton = Operations.determinize((Automaton)automaton, (int)10000)))) {
            throw new IllegalArgumentException("Refusing to start because allowlist " + String.valueOf(allowlist) + " accepts all addresses. This would allow users to reindex-from-remote any URL they like effectively having OpenSearch make HTTP GETs for them.");
        }
        return new CharacterRunAutomaton(automaton);
    }

    static void validateAgainstAliases(SearchRequest source, IndexRequest destination, RemoteInfo remoteInfo, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, ClusterState clusterState) {
        if (remoteInfo != null) {
            return;
        }
        String target = destination.index();
        if (destination.isRequireAlias() && !clusterState.getMetadata().hasAlias(target)) {
            throw new IndexNotFoundException("[require_alias] request flag is [true] and [" + target + "] is not an alias", target);
        }
        if (!autoCreateIndex.shouldAutoCreate(target, clusterState)) {
            target = indexNameExpressionResolver.concreteWriteIndex(clusterState, (IndicesRequest)destination).getName();
        }
        for (String sourceIndex : indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)source)) {
            if (!sourceIndex.equals(target)) continue;
            ActionRequestValidationException e = new ActionRequestValidationException();
            e.addValidationError("reindex cannot write into an index its reading from [" + target + "]");
            throw e;
        }
    }
}

