/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.neighbour.kdtree;

import org.tribuo.math.distance.Distance;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.neighbour.kdtree.KDTree;

final class DimensionNode {
    private final int dimension;
    private final KDTree.IntAndVector intAndVector;
    private final int maxD;
    private final double coord;
    private final Distance distance;
    private DimensionNode below;
    private DimensionNode above;

    DimensionNode(int dimension, KDTree.IntAndVector intAndVector, Distance distance) {
        this.dimension = dimension;
        this.intAndVector = intAndVector;
        this.maxD = intAndVector.vector.size() - 1;
        this.distance = distance;
        this.coord = intAndVector.vector.get(dimension);
    }

    DimensionNode getBelow() {
        return this.below;
    }

    DimensionNode getAbove() {
        return this.above;
    }

    void setBelow(DimensionNode node) {
        if (node == null) {
            this.below = null;
        } else if (this.dimension + 1 == node.dimension || this.dimension == this.maxD && node.dimension == 0) {
            this.below = node;
        } else {
            throw new IllegalArgumentException("Setting the below/left node failed because the dimensions are incorrect.");
        }
    }

    void setAbove(DimensionNode node) {
        if (node == null) {
            this.above = null;
        } else if (this.dimension + 1 == node.dimension || this.dimension == this.maxD && node.dimension == 0) {
            this.above = node;
        } else {
            throw new IllegalArgumentException("Setting the above/right node failed because the dimensions are incorrect.");
        }
    }

    boolean isBelow(SGDVector point) {
        return point.get(this.dimension) < this.coord;
    }

    void nearest(SGDVector point, KDTree.DistanceIntAndVectorBoundedMinHeap queue, boolean isInitializing) {
        if (isInitializing && queue.isFull()) {
            return;
        }
        double dist = this.distance.computeDistance(this.intAndVector.vector, point);
        queue.boundedOffer(this.intAndVector, dist);
        double distPerp = Math.abs(this.coord - point.get(this.dimension));
        if (Double.compare(distPerp, queue.peek().dist) <= 0) {
            if (this.above != null) {
                this.above.nearest(point, queue, isInitializing);
            }
            if (this.below != null) {
                this.below.nearest(point, queue, isInitializing);
            }
        } else if (point.get(this.dimension) < this.coord) {
            if (this.below != null) {
                this.below.nearest(point, queue, isInitializing);
            }
        } else if (this.above != null) {
            this.above.nearest(point, queue, isInitializing);
        }
    }
}

