/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.optimisers;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.logging.Logger;
import org.tribuo.math.Parameters;
import org.tribuo.math.StochasticGradientOptimiser;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.la.Matrix;
import org.tribuo.math.la.MatrixIterator;
import org.tribuo.math.la.MatrixTuple;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.Tensor;
import org.tribuo.math.la.VectorIterator;
import org.tribuo.math.la.VectorTuple;
import org.tribuo.math.protos.AdaGradRDADenseTensorProto;
import org.tribuo.math.protos.DenseTensorProto;
import org.tribuo.math.protos.TensorProto;

public class AdaGradRDA
implements StochasticGradientOptimiser {
    private static final Logger logger = Logger.getLogger(AdaGradRDA.class.getName());
    @Config(mandatory=true, description="Initial learning rate used to scale the gradients.")
    private double initialLearningRate;
    @Config(description="Epsilon for numerical stability around zero.")
    private double epsilon = 1.0E-6;
    @Config(description="l1 regularization penalty.")
    private double l1 = 0.0;
    @Config(description="l2 regularization penalty.")
    private double l2 = 0.0;
    @Config(description="Number of examples to scale the l1 and l2 penalties by.")
    private int numExamples = 1;
    private Parameters parameters = null;

    public AdaGradRDA(double initialLearningRate, double epsilon, double l1, double l2, int numExamples) {
        this.initialLearningRate = initialLearningRate;
        this.epsilon = epsilon;
        this.l1 = l1;
        this.l2 = l2;
        this.numExamples = numExamples;
    }

    public AdaGradRDA(double initialLearningRate, double epsilon) {
        this(initialLearningRate, epsilon, 0.0, 0.0, 1);
    }

    private AdaGradRDA() {
    }

    @Override
    public void initialise(Parameters parameters) {
        this.parameters = parameters;
        Tensor[] curParams = parameters.get();
        Tensor[] newParams = new Tensor[curParams.length];
        for (int i = 0; i < newParams.length; ++i) {
            if (curParams[i] instanceof DenseVector) {
                newParams[i] = new AdaGradRDAVector((DenseVector)curParams[i], this.initialLearningRate, this.epsilon, this.l1 / (double)this.numExamples, this.l2 / (double)this.numExamples);
                continue;
            }
            if (curParams[i] instanceof DenseMatrix) {
                newParams[i] = new AdaGradRDAMatrix((DenseMatrix)curParams[i], this.initialLearningRate, this.epsilon, this.l1 / (double)this.numExamples, this.l2 / (double)this.numExamples);
                continue;
            }
            throw new IllegalStateException("Unknown Tensor subclass");
        }
        parameters.set(newParams);
    }

    @Override
    public Tensor[] step(Tensor[] updates, double weight) {
        for (Tensor update : updates) {
            update.scaleInPlace(weight);
        }
        return updates;
    }

    @Override
    public void finalise() {
        Tensor[] curParams = this.parameters.get();
        Tensor[] newParams = new Tensor[curParams.length];
        for (int i = 0; i < newParams.length; ++i) {
            if (!(curParams[i] instanceof AdaGradRDATensor)) {
                throw new IllegalStateException("Finalising a Parameters which wasn't initialised with AdaGradRDA");
            }
            newParams[i] = ((AdaGradRDATensor)((Object)curParams[i])).convertToDense();
        }
        this.parameters.set(newParams);
    }

    public String toString() {
        return "AdaGradRDA(initialLearningRate=" + this.initialLearningRate + ",epsilon=" + this.epsilon + ",l1=" + this.l1 + ",l2=" + this.l2 + ")";
    }

    @Override
    public void reset() {
        this.parameters = null;
    }

    @Override
    public AdaGradRDA copy() {
        return new AdaGradRDA(this.initialLearningRate, this.epsilon, this.l1, this.l2, this.numExamples);
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "StochasticGradientOptimiser");
    }

    private static class AdaGradRDAVector
    extends DenseVector
    implements AdaGradRDATensor {
        private final double learningRate;
        private final double epsilon;
        private final double l1;
        private final double l2;
        private final double[] gradSquares;
        private int iteration;

        AdaGradRDAVector(DenseVector v, double learningRate, double epsilon, double l1, double l2) {
            super(v);
            this.learningRate = learningRate;
            this.epsilon = epsilon;
            this.l1 = l1;
            this.l2 = l2;
            this.gradSquares = new double[v.size()];
            this.iteration = 0;
        }

        private AdaGradRDAVector(double[] v, double learningRate, double epsilon, double l1, double l2, double[] gradSquares, int iteration) {
            super(v);
            this.learningRate = learningRate;
            this.epsilon = epsilon;
            this.l1 = l1;
            this.l2 = l2;
            this.gradSquares = gradSquares;
            if (gradSquares.length != v.length) {
                throw new IllegalArgumentException("Invalid AdaGradRDAVector, value vector is a different shape to gradient vector, value [" + v.length + "], gradient [" + gradSquares.length + "]");
            }
            for (int i = 0; i < gradSquares.length; ++i) {
                if (!(gradSquares[i] < 0.0)) continue;
                throw new IllegalArgumentException("Invalid AdaGradRDAVector, squared gradient is negative at index [" + i + "] = " + gradSquares[i]);
            }
            this.iteration = iteration;
            if (iteration < 0) {
                throw new IllegalArgumentException("Invalid AdaGradRDAVector, iteration must be non-negative, found " + iteration);
            }
        }

        public static AdaGradRDAVector deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
            if (version < 0 || version > 0) {
                throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
            }
            AdaGradRDADenseTensorProto proto = (AdaGradRDADenseTensorProto)message.unpack(AdaGradRDADenseTensorProto.class);
            DenseVector data = DenseVector.unpackProto(proto.getData());
            DoubleBuffer buffer = proto.getGradNorms().asReadOnlyByteBuffer().asDoubleBuffer();
            if (buffer.remaining() != data.size()) {
                throw new IllegalArgumentException("Invalid proto, claimed " + data.size() + ", but only had " + buffer.remaining() + " values");
            }
            double[] values = new double[data.size()];
            buffer.get(values);
            return new AdaGradRDAVector(data.toArray(), proto.getLearningRate(), proto.getEpsilon(), proto.getL1(), proto.getL2(), values, proto.getIteration());
        }

        @Override
        public TensorProto serialize() {
            TensorProto.Builder builder = TensorProto.newBuilder();
            builder.setVersion(0);
            builder.setClassName(AdaGradRDAVector.class.getName());
            AdaGradRDADenseTensorProto.Builder adagradBuilder = AdaGradRDADenseTensorProto.newBuilder();
            DenseTensorProto.Builder dataBuilder = DenseTensorProto.newBuilder();
            dataBuilder.addDimensions(this.size());
            ByteBuffer buffer = ByteBuffer.allocate(this.elements.length * 8).order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
            doubleBuffer.put(this.elements);
            doubleBuffer.rewind();
            dataBuilder.setValues(ByteString.copyFrom((ByteBuffer)buffer));
            adagradBuilder.setData(dataBuilder.build());
            adagradBuilder.setLearningRate(this.learningRate);
            adagradBuilder.setEpsilon(this.epsilon);
            adagradBuilder.setL1(this.l1);
            adagradBuilder.setL2(this.l2);
            buffer = ByteBuffer.allocate(this.gradSquares.length * 8).order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = buffer.asDoubleBuffer();
            doubleBuffer.put(this.gradSquares);
            doubleBuffer.rewind();
            adagradBuilder.setGradNorms(ByteString.copyFrom((ByteBuffer)buffer));
            adagradBuilder.setIteration(this.iteration);
            builder.setSerializedData(Any.pack((Message)adagradBuilder.build()));
            return builder.build();
        }

        @Override
        public DenseVector convertToDense() {
            return DenseVector.createDenseVector(this.toArray());
        }

        @Override
        public AdaGradRDAVector copy() {
            return new AdaGradRDAVector(Arrays.copyOf(this.elements, this.elements.length), this.learningRate, this.epsilon, this.l1, this.l2, Arrays.copyOf(this.gradSquares, this.gradSquares.length), this.iteration);
        }

        @Override
        public double[] toArray() {
            double[] newValues = new double[this.elements.length];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = this.get(i);
            }
            return newValues;
        }

        @Override
        public double get(int index) {
            if (this.gradSquares[index] == 0.0) {
                return this.elements[index];
            }
            double h = (Math.sqrt(this.gradSquares[index]) + this.epsilon) / this.learningRate + (double)this.iteration * this.l2;
            double rate = 1.0 / h;
            return rate * AdaGradRDATensor.truncate(this.elements[index], (double)this.iteration * this.l1);
        }

        @Override
        public double sum() {
            double sum = 0.0;
            for (int i = 0; i < this.elements.length; ++i) {
                sum += this.get(i);
            }
            return sum;
        }

        @Override
        public void intersectAndAddInPlace(Tensor other, DoubleUnaryOperator f) {
            ++this.iteration;
            SGDVector otherVec = (SGDVector)other;
            for (VectorTuple tuple : otherVec) {
                double update = f.applyAsDouble(tuple.value);
                int n = tuple.index;
                this.elements[n] = this.elements[n] + update;
                int n2 = tuple.index;
                this.gradSquares[n2] = this.gradSquares[n2] + update * update;
            }
        }

        @Override
        public int indexOfMax() {
            int index = 0;
            double value = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.elements.length; ++i) {
                double tmp = this.get(i);
                if (!(tmp > value)) continue;
                index = i;
                value = tmp;
            }
            return index;
        }

        @Override
        public double maxValue() {
            double value = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.elements.length; ++i) {
                double tmp = this.get(i);
                if (!(tmp > value)) continue;
                value = tmp;
            }
            return value;
        }

        @Override
        public double minValue() {
            double value = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.elements.length; ++i) {
                double tmp = this.get(i);
                if (!(tmp < value)) continue;
                value = tmp;
            }
            return value;
        }

        @Override
        public double dot(SGDVector other) {
            double score = 0.0;
            for (VectorTuple tuple : other) {
                score += this.get(tuple.index) * tuple.value;
            }
            return score;
        }

        @Override
        public VectorIterator iterator() {
            return new RDAVectorIterator(this);
        }

        private static class RDAVectorIterator
        implements VectorIterator {
            private final AdaGradRDAVector vector;
            private final VectorTuple tuple;
            private int index;

            public RDAVectorIterator(AdaGradRDAVector vector) {
                this.vector = vector;
                this.tuple = new VectorTuple();
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.vector.size();
            }

            @Override
            public VectorTuple next() {
                this.tuple.index = this.index;
                this.tuple.value = this.vector.get(this.index);
                ++this.index;
                return this.tuple;
            }

            @Override
            public VectorTuple getReference() {
                return this.tuple;
            }
        }
    }

    private static class AdaGradRDAMatrix
    extends DenseMatrix
    implements AdaGradRDATensor {
        private final double learningRate;
        private final double epsilon;
        private final double l1;
        private final double l2;
        private final double[][] gradSquares;
        private int iteration;

        AdaGradRDAMatrix(DenseMatrix v, double learningRate, double epsilon, double l1, double l2) {
            super(v);
            this.learningRate = learningRate;
            this.epsilon = epsilon;
            this.l1 = l1;
            this.l2 = l2;
            this.gradSquares = new double[v.getDimension1Size()][v.getDimension2Size()];
            this.iteration = 0;
        }

        private AdaGradRDAMatrix(DenseMatrix v, double learningRate, double epsilon, double l1, double l2, double[][] gradSquares, int iteration) {
            super(v);
            this.learningRate = learningRate;
            this.epsilon = epsilon;
            this.l1 = l1;
            this.l2 = l2;
            this.gradSquares = gradSquares;
            if (gradSquares.length != this.dim1 || gradSquares[0].length != this.dim2) {
                throw new IllegalArgumentException("Invalid AdaGradRDAMatrix, value matrix is a different shape to gradient matrix, value [" + this.dim1 + ", " + this.dim2 + "], gradient [" + gradSquares.length + ", " + gradSquares[0].length + "]");
            }
            for (int i = 0; i < gradSquares.length; ++i) {
                if (gradSquares[i].length != this.dim2) {
                    throw new IllegalArgumentException("Invalid AdaGradRDAMatrix, gradient matrix is ragged, expected " + this.dim2 + ", found " + gradSquares[i].length + " at index " + i);
                }
                for (int j = 0; j < gradSquares[i].length; ++j) {
                    if (!(gradSquares[i][j] < 0.0)) continue;
                    throw new IllegalArgumentException("Invalid AdaGradRDAMatrix, squared gradient is negative at index [" + i + ", " + j + "] = " + gradSquares[i][j]);
                }
            }
            this.iteration = iteration;
            if (iteration < 0) {
                throw new IllegalArgumentException("Invalid AdaGradRDAMatrix, iteration must be non-negative, found " + iteration);
            }
        }

        public static AdaGradRDAMatrix deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
            if (version < 0 || version > 0) {
                throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
            }
            AdaGradRDADenseTensorProto proto = (AdaGradRDADenseTensorProto)message.unpack(AdaGradRDADenseTensorProto.class);
            DenseMatrix data = DenseMatrix.unpackProto(proto.getData());
            DoubleBuffer buffer = proto.getGradNorms().asReadOnlyByteBuffer().asDoubleBuffer();
            if (buffer.remaining() != data.getDimension1Size() * data.getDimension2Size()) {
                throw new IllegalArgumentException("Invalid proto, claimed " + data.getDimension1Size() * data.getDimension2Size() + ", but only had " + buffer.remaining() + " values");
            }
            double[][] values = new double[data.getDimension1Size()][data.getDimension2Size()];
            for (int i = 0; i < values.length; ++i) {
                buffer.get(values[i]);
            }
            return new AdaGradRDAMatrix(data, proto.getLearningRate(), proto.getEpsilon(), proto.getL1(), proto.getL2(), values, proto.getIteration());
        }

        @Override
        public TensorProto serialize() {
            int i;
            TensorProto.Builder builder = TensorProto.newBuilder();
            builder.setVersion(0);
            builder.setClassName(AdaGradRDAMatrix.class.getName());
            AdaGradRDADenseTensorProto.Builder adagradBuilder = AdaGradRDADenseTensorProto.newBuilder();
            DenseTensorProto.Builder dataBuilder = DenseTensorProto.newBuilder();
            dataBuilder.addDimensions(this.dim1);
            dataBuilder.addDimensions(this.dim2);
            ByteBuffer buffer = ByteBuffer.allocate(this.dim1 * this.dim2 * 8).order(ByteOrder.LITTLE_ENDIAN);
            DoubleBuffer doubleBuffer = buffer.asDoubleBuffer();
            for (i = 0; i < this.values.length; ++i) {
                doubleBuffer.put(this.values[i]);
            }
            doubleBuffer.rewind();
            dataBuilder.setValues(ByteString.copyFrom((ByteBuffer)buffer));
            adagradBuilder.setData(dataBuilder.build());
            adagradBuilder.setLearningRate(this.learningRate);
            adagradBuilder.setEpsilon(this.epsilon);
            adagradBuilder.setL1(this.l1);
            adagradBuilder.setL2(this.l2);
            buffer = ByteBuffer.allocate(this.dim1 * this.dim2 * 8).order(ByteOrder.LITTLE_ENDIAN);
            doubleBuffer = buffer.asDoubleBuffer();
            for (i = 0; i < this.gradSquares.length; ++i) {
                doubleBuffer.put(this.gradSquares[i]);
            }
            doubleBuffer.rewind();
            adagradBuilder.setGradNorms(ByteString.copyFrom((ByteBuffer)buffer));
            adagradBuilder.setIteration(this.iteration);
            builder.setSerializedData(Any.pack((Message)adagradBuilder.build()));
            return builder.build();
        }

        @Override
        public DenseMatrix convertToDense() {
            return new DenseMatrix(this);
        }

        @Override
        public DenseVector leftMultiply(SGDVector input) {
            if (input.size() == this.dim2) {
                double[] output = new double[this.dim1];
                for (VectorTuple tuple : input) {
                    for (int i = 0; i < output.length; ++i) {
                        int n = i;
                        output[n] = output[n] + this.get(i, tuple.index) * tuple.value;
                    }
                }
                return DenseVector.createDenseVector(output);
            }
            throw new IllegalArgumentException("input.size() != dim2");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void intersectAndAddInPlace(Tensor other, DoubleUnaryOperator f) {
            if (!(other instanceof Matrix)) throw new IllegalStateException("Adding a non-Matrix to a Matrix");
            Matrix otherMat = (Matrix)other;
            if (this.dim1 != otherMat.getDimension1Size() || this.dim2 != otherMat.getDimension2Size()) throw new IllegalStateException("Matrices are not the same size, this(" + this.dim1 + "," + this.dim2 + "), other(" + otherMat.getDimension1Size() + "," + otherMat.getDimension2Size() + ")");
            for (MatrixTuple tuple : otherMat) {
                double update = f.applyAsDouble(tuple.value);
                double[] dArray = this.values[tuple.i];
                int n = tuple.j;
                dArray[n] = dArray[n] + update;
                double[] dArray2 = this.gradSquares[tuple.i];
                int n2 = tuple.j;
                dArray2[n2] = dArray2[n2] + update * update;
            }
        }

        @Override
        public double get(int i, int j) {
            if (this.gradSquares[i][j] == 0.0) {
                return this.values[i][j];
            }
            double h = (Math.sqrt(this.gradSquares[i][j]) + this.epsilon) / this.learningRate + (double)this.iteration * this.l2;
            double rate = 1.0 / h;
            return rate * AdaGradRDATensor.truncate(this.values[i][j], (double)this.iteration * this.l1);
        }

        @Override
        public MatrixIterator iterator() {
            return new RDAMatrixIterator(this);
        }

        private static class RDAMatrixIterator
        implements MatrixIterator {
            private final AdaGradRDAMatrix matrix;
            private final MatrixTuple tuple;
            private final int dim2;
            private int i;
            private int j;

            public RDAMatrixIterator(AdaGradRDAMatrix matrix) {
                this.matrix = matrix;
                this.tuple = new MatrixTuple();
                this.dim2 = matrix.dim2;
                this.i = 0;
                this.j = 0;
            }

            @Override
            public MatrixTuple getReference() {
                return this.tuple;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.matrix.dim1 && this.j < this.matrix.dim2;
            }

            @Override
            public MatrixTuple next() {
                this.tuple.i = this.i;
                this.tuple.j = this.j;
                this.tuple.value = this.matrix.get(this.i, this.j);
                if (this.j < this.dim2 - 1) {
                    ++this.j;
                } else {
                    ++this.i;
                    this.j = 0;
                }
                return this.tuple;
            }
        }
    }

    private static interface AdaGradRDATensor {
        public Tensor convertToDense();

        public static double truncate(double input, double threshold) {
            if (input > threshold) {
                return input - threshold;
            }
            if (input < -threshold) {
                return input + threshold;
            }
            return 0.0;
        }
    }
}

