/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.util;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.tribuo.math.protos.NormalizerProto;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.util.onnx.ONNXContext;
import org.tribuo.util.onnx.ONNXInitializer;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXOperator;
import org.tribuo.util.onnx.ONNXOperators;
import org.tribuo.util.onnx.ONNXRef;

public class Normalizer
implements VectorNormalizer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;

    public static Normalizer deserializeFromProto(int version, String className, Any message) {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        if (message.getValue() != ByteString.EMPTY) {
            throw new IllegalArgumentException("Invalid proto");
        }
        return new Normalizer();
    }

    public NormalizerProto serialize() {
        NormalizerProto.Builder normalizerProto = NormalizerProto.newBuilder();
        normalizerProto.setClassName(this.getClass().getName());
        normalizerProto.setVersion(0);
        return normalizerProto.build();
    }

    @Override
    public double[] normalize(double[] input) {
        double[] output = Arrays.copyOf(input, input.length);
        this.normalizeInPlace(output);
        return output;
    }

    @Override
    public void normalizeInPlace(double[] input) {
        int i;
        double min = Double.MAX_VALUE;
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (!(min > input[i2])) continue;
            min = input[i2];
        }
        min -= 0.01;
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            int n = i;
            input[n] = input[n] - min;
            sum += input[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            input[n] = input[n] / sum;
        }
    }

    @Override
    public ONNXNode exportNormalizer(ONNXNode input) {
        ONNXContext onnx = input.onnxContext();
        ONNXInitializer sumAxes = onnx.array("sum_axes", new long[]{1L});
        ONNXNode min = input.apply((ONNXOperator)ONNXOperators.REDUCE_MIN, Collections.singletonMap("axes", new int[]{1}));
        ONNXNode sub = input.apply((ONNXOperator)ONNXOperators.SUB, (ONNXRef)min);
        ONNXNode sum = sub.apply((ONNXOperator)ONNXOperators.REDUCE_SUM, (ONNXRef)sumAxes);
        return sub.apply((ONNXOperator)ONNXOperators.DIV, (ONNXRef)sum);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 31;
    }
}

