/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.util;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Arrays;
import org.tribuo.math.protos.NormalizerProto;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXOperator;
import org.tribuo.util.onnx.ONNXOperators;

public class SigmoidNormalizer
implements VectorNormalizer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CURRENT_VERSION = 0;

    public static SigmoidNormalizer deserializeFromProto(int version, String className, Any message) {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        if (message.getValue() != ByteString.EMPTY) {
            throw new IllegalArgumentException("Invalid proto");
        }
        return new SigmoidNormalizer();
    }

    public NormalizerProto serialize() {
        NormalizerProto.Builder normalizerProto = NormalizerProto.newBuilder();
        normalizerProto.setClassName(this.getClass().getName());
        normalizerProto.setVersion(0);
        return normalizerProto.build();
    }

    public static double sigmoid(double input) {
        return 1.0 / (1.0 + Math.exp(-input));
    }

    @Override
    public double[] normalize(double[] input) {
        double[] output = Arrays.copyOf(input, input.length);
        this.normalizeInPlace(output);
        return output;
    }

    @Override
    public void normalizeInPlace(double[] input) {
        for (int i = 0; i < input.length; ++i) {
            input[i] = SigmoidNormalizer.sigmoid(input[i]);
        }
    }

    @Override
    public ONNXNode exportNormalizer(ONNXNode input) {
        return input.apply((ONNXOperator)ONNXOperators.SIGMOID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 31;
    }
}

