/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.azure;

import com.azure.storage.blob.models.BlobStorageException;
import io.lucenia.repositories.azure.AzureBlobStore;
import io.lucenia.repositories.azure.LocationMode;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobMetadata;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.common.blobstore.DeleteResult;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.GroupedActionListener;
import io.skylite.core.action.support.PlainActionFuture;
import io.skylite.core.blobstore.AbstractBlobContainer;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AzureBlobContainer
extends AbstractBlobContainer {
    public static final int DEFAULT_MINIMUM_READ_SIZE_IN_BYTES = 0x400000;
    private final Logger logger = LogManager.getLogger(AzureBlobContainer.class);
    private final AzureBlobStore blobStore;
    private final ThreadPool threadPool;
    private final String keyPath;

    AzureBlobContainer(BlobPath path, AzureBlobStore blobStore, ThreadPool threadPool) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
        this.threadPool = threadPool;
    }

    public boolean blobExists(String blobName) {
        this.logger.trace("blobExists({})", (Object)blobName);
        try {
            return this.blobStore.blobExists(this.buildKey(blobName));
        }
        catch (BlobStorageException | URISyntaxException e) {
            this.logger.warn("can not access [{}] in container {{}}: {}", (Object)blobName, (Object)this.blobStore, (Object)e.getMessage());
            return false;
        }
    }

    private InputStream openInputStream(String blobName, long position, @Nullable Long length) throws IOException {
        this.logger.trace("readBlob({}) from position [{}] with length [{}]", (Object)blobName, (Object)position, length != null ? length : "unlimited");
        if (this.blobStore.getLocationMode() == LocationMode.SECONDARY_ONLY && !this.blobExists(blobName)) {
            throw new NoSuchFileException("Blob [" + blobName + "] does not exist");
        }
        try {
            return this.blobStore.getInputStream(this.buildKey(blobName), position, length);
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 404) {
                throw new NoSuchFileException(e.getMessage());
            }
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public InputStream readBlob(String blobName) throws IOException {
        return this.openInputStream(blobName, 0L, null);
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        return this.openInputStream(blobName, position, length);
    }

    public long readBlobPreferredLength() {
        return 0x400000L;
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.logger.trace("writeBlob({}, stream, {})", (Object)this.buildKey(blobName), (Object)blobSize);
        try {
            this.blobStore.writeBlob(this.buildKey(blobName), inputStream, blobSize, failIfAlreadyExists);
        }
        catch (BlobStorageException | URISyntaxException e) {
            throw new IOException("Can not write blob " + blobName, e);
        }
    }

    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    public DeleteResult delete() throws IOException {
        try {
            return this.blobStore.deleteBlobDirectory(this.keyPath, this.threadPool.executor("repository_azure"));
        }
        catch (BlobStorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        PlainActionFuture result = PlainActionFuture.newFuture();
        if (blobNames.isEmpty()) {
            result.onResponse(null);
        } else {
            GroupedActionListener listener = new GroupedActionListener(ActionListenerHelper.map((ActionListener)result, v -> null), blobNames.size());
            ExecutorService executor = this.threadPool.executor("repository_azure");
            for (String blobName : blobNames) {
                executor.execute((Runnable)ActionRunnable.run((ActionListener)listener, () -> {
                    this.logger.trace("deleteBlob({})", (Object)blobName);
                    try {
                        this.blobStore.deleteBlob(this.buildKey(blobName));
                    }
                    catch (BlobStorageException e) {
                        if (e.getStatusCode() != 404) {
                            throw new IOException(e);
                        }
                    }
                    catch (URISyntaxException e) {
                        throw new IOException(e);
                    }
                }));
            }
        }
        try {
            result.actionGet();
        }
        catch (Exception e) {
            throw new IOException("Exception during bulk delete", e);
        }
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(@Nullable String prefix) throws IOException {
        this.logger.trace("listBlobsByPrefix({})", (Object)prefix);
        try {
            return this.blobStore.listBlobsByPrefix(this.keyPath, prefix);
        }
        catch (BlobStorageException | URISyntaxException e) {
            this.logger.warn("can not access [{}] in container {{}}: {}", (Object)prefix, (Object)this.blobStore, (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        this.logger.trace("listBlobs()");
        return this.listBlobsByPrefix(null);
    }

    public Map<String, BlobContainer> children() throws IOException {
        BlobPath path = this.path();
        try {
            return this.blobStore.children(path);
        }
        catch (BlobStorageException | URISyntaxException e) {
            throw new IOException("Failed to list children in path [" + path.buildAsString() + "].", e);
        }
    }

    protected String buildKey(String blobName) {
        return this.keyPath + (blobName == null ? "" : blobName);
    }
}

