/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.tools.launchers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

final class SystemJvmOptions {
    SystemJvmOptions() {
    }

    static List<String> systemJvmOptions() {
        return Stream.of(Stream.of("-Dlucenia.networkaddress.cache.ttl=60", "-Dlucenia.networkaddress.cache.negative.ttl=10", "-XX:+AlwaysPreTouch", "-Xss1m", "-Djava.awt.headless=true", "-Dfile.encoding=UTF-8", "-Djna.nosys=true", "-XX:-OmitStackTraceInFastThrow", SystemJvmOptions.maybeShowCodeDetailsInExceptionMessages(), "-Dio.netty.noUnsafe=true", "-Dio.netty.noKeySetOptimization=true", "-Dio.netty.recycler.maxCapacityPerThread=0", "-Dio.netty.allocator.numDirectArenas=0", "-Dlog4j.shutdownHookEnabled=false", "-Dlog4j2.disable.jmx=true", SystemJvmOptions.allowSecurityManagerOption(), "-Djava.locale.providers=" + SystemJvmOptions.javaLocaleProviders()), SystemJvmOptions.maybeEnableNativeAccess()).flatMap(s -> s).toList();
    }

    private static String allowSecurityManagerOption() {
        if (Runtime.version().feature() > 17) {
            return "-Djava.security.manager=allow";
        }
        return "";
    }

    private static String maybeShowCodeDetailsInExceptionMessages() {
        if (Runtime.version().feature() >= 14) {
            return "-XX:+ShowCodeDetailsInExceptionMessages";
        }
        return "";
    }

    private static Stream<String> maybeEnableNativeAccess() {
        ArrayList<String> enableNativeAccessOptions = new ArrayList<String>();
        if (Runtime.version().feature() >= 21) {
            enableNativeAccessOptions.add("--enable-native-access=org.apache.lucene.core");
            enableNativeAccessOptions.add("--enable-native-access=ALL-UNNAMED");
            if (Runtime.version().feature() >= 24) {
                enableNativeAccessOptions.add("--illegal-native-access=deny");
            }
        }
        return enableNativeAccessOptions.stream();
    }

    private static String javaLocaleProviders() {
        return Runtime.version().feature() >= 23 ? "SPI,CLDR" : "SPI,COMPAT";
    }
}

