/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.rankeval;

import io.lucenia.index.rankeval.RankEvalSpec;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.search.SearchType;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class RankEvalRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    private RankEvalSpec rankingEvaluationSpec;
    private IndicesOptions indicesOptions = SearchExecutionContext.DEFAULT_INDICES_OPTIONS;
    private String[] indices = Strings.EMPTY_ARRAY;
    private SearchType searchType = SearchType.DEFAULT;

    public RankEvalRequest(RankEvalSpec rankingEvaluationSpec, String[] indices) {
        this.rankingEvaluationSpec = Objects.requireNonNull(rankingEvaluationSpec, "ranking evaluation specification must not be null");
        this.indices(indices);
    }

    RankEvalRequest(StreamInput in) throws IOException {
        super(in);
        this.rankingEvaluationSpec = new RankEvalSpec(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        this.searchType = SearchType.fromId((byte)in.readByte());
    }

    RankEvalRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = null;
        if (this.rankingEvaluationSpec == null) {
            e = new ActionRequestValidationException();
            e.addValidationError("missing ranking evaluation specification");
        }
        return e;
    }

    public RankEvalSpec getRankEvalSpec() {
        return this.rankingEvaluationSpec;
    }

    public void setRankEvalSpec(RankEvalSpec task) {
        this.rankingEvaluationSpec = task;
    }

    public RankEvalRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (String index : indices) {
            Objects.requireNonNull(index, "index must not be null");
        }
        this.indices = indices;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public void indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indicesOptions must not be null");
    }

    public void searchType(SearchType searchType) {
        this.searchType = Objects.requireNonNull(searchType, "searchType must not be null");
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.rankingEvaluationSpec.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeByte(this.searchType.id());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RankEvalRequest that = (RankEvalRequest)((Object)o);
        return Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.rankingEvaluationSpec, that.rankingEvaluationSpec) && Objects.equals(this.searchType, that.searchType);
    }

    public int hashCode() {
        return Objects.hash(this.indicesOptions, Arrays.hashCode(this.indices), this.rankingEvaluationSpec, this.searchType);
    }
}

