/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.rankeval;

import io.lucenia.index.rankeval.EvalQueryQuality;
import io.skylite.SkyliteException;
import io.skylite.common.collect.Tuple;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RankEvalResponse
extends ActionResponse
implements ToXContentObject {
    private double metricScore;
    private Map<String, EvalQueryQuality> details;
    private Map<String, Exception> failures;
    private static final ParseField DETAILS_FIELD = new ParseField("details", new String[0]);
    private static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);
    private static final ConstructingObjectParser<RankEvalResponse, Void> PARSER = new ConstructingObjectParser("rank_eval_response", true, a -> new RankEvalResponse((Double)a[0], ((List)a[1]).stream().collect(Collectors.toMap(EvalQueryQuality::getId, Function.identity())), ((List)a[2]).stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2))));

    public RankEvalResponse(double metricScore, Map<String, EvalQueryQuality> partialResults, Map<String, Exception> failures) {
        this.metricScore = metricScore;
        this.details = new HashMap<String, EvalQueryQuality>(partialResults);
        this.failures = new HashMap<String, Exception>(failures);
    }

    RankEvalResponse(StreamInput in) throws IOException {
        super(in);
        this.metricScore = in.readDouble();
        int partialResultSize = in.readVInt();
        this.details = new HashMap<String, EvalQueryQuality>(partialResultSize);
        for (int i = 0; i < partialResultSize; ++i) {
            String queryId = in.readString();
            EvalQueryQuality partial = new EvalQueryQuality(in);
            this.details.put(queryId, partial);
        }
        int failuresSize = in.readVInt();
        this.failures = new HashMap<String, Exception>(failuresSize);
        for (int i = 0; i < failuresSize; ++i) {
            String queryId = in.readString();
            this.failures.put(queryId, in.readException());
        }
    }

    public double getMetricScore() {
        return this.metricScore;
    }

    public Map<String, EvalQueryQuality> getPartialResults() {
        return Collections.unmodifiableMap(this.details);
    }

    public Map<String, Exception> getFailures() {
        return Collections.unmodifiableMap(this.failures);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.metricScore);
        out.writeVInt(this.details.size());
        for (String queryId : this.details.keySet()) {
            out.writeString(queryId);
            this.details.get(queryId).writeTo(out);
        }
        out.writeVInt(this.failures.size());
        for (String queryId : this.failures.keySet()) {
            out.writeString(queryId);
            out.writeException((Throwable)this.failures.get(queryId));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("metric_score", this.metricScore);
        builder.startObject("details");
        for (String key : this.details.keySet()) {
            this.details.get(key).toXContent(builder, params);
        }
        builder.endObject();
        builder.startObject("failures");
        for (String key : this.failures.keySet()) {
            builder.startObject(key);
            SkyliteException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.failures.get(key), (boolean)true);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static RankEvalResponse fromXContent(XContentParser parser) throws IOException {
        return (RankEvalResponse)((Object)PARSER.apply(parser, null));
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), EvalQueryQuality.METRIC_SCORE_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> EvalQueryQuality.fromXContent(p, n), DETAILS_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)p.nextToken(), (XContentParser)p);
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)p.nextToken(), (XContentParser)p);
            Tuple tuple = new Tuple((Object)n, (Object)SkyliteException.failureFromXContent((XContentParser)p));
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)p.nextToken(), (XContentParser)p);
            return tuple;
        }, FAILURES_FIELD);
    }
}

