/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.index.rankeval;

import io.lucenia.index.rankeval.RankEvalAction;
import io.lucenia.index.rankeval.RankEvalRequest;
import io.lucenia.index.rankeval.RankEvalSpec;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.search.SearchType;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestRankEvalAction
extends BaseRestHandler {
    public static String ENDPOINT = "_rank_eval";

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/" + ENDPOINT), new RestHandler.Route(RestRequest.Method.POST, "/" + ENDPOINT), new RestHandler.Route(RestRequest.Method.GET, "/{index}/" + ENDPOINT), new RestHandler.Route(RestRequest.Method.POST, "/{index}/" + ENDPOINT)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        RankEvalRequest rankEvalRequest = new RankEvalRequest();
        try (XContentParser parser = request.contentOrSourceParamParser();){
            RestRankEvalAction.parseRankEvalRequest(rankEvalRequest, request, parser);
        }
        return channel -> client.executeLocally((ActionType)RankEvalAction.INSTANCE, (ActionRequest)rankEvalRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private static void parseRankEvalRequest(RankEvalRequest rankEvalRequest, RestRequest request, XContentParser parser) {
        rankEvalRequest.indices(Strings.splitStringByCommaToArray((String)request.param("index")));
        rankEvalRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)rankEvalRequest.indicesOptions()));
        if (request.hasParam("search_type")) {
            rankEvalRequest.searchType(SearchType.fromString((String)request.param("search_type")));
        }
        RankEvalSpec spec = RankEvalSpec.parse(parser);
        rankEvalRequest.setRankEvalSpec(spec);
    }

    public String getName() {
        return "rank_eval_action";
    }
}

