/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputInfo;
import org.tribuo.anomaly.AnomalyFactory;
import org.tribuo.anomaly.Event;
import org.tribuo.anomaly.ImmutableAnomalyInfo;
import org.tribuo.anomaly.MutableAnomalyInfo;
import org.tribuo.protos.ProtoSerializable;
import org.tribuo.protos.ProtoSerializableField;
import org.tribuo.protos.ProtoUtil;
import org.tribuo.protos.core.OutputDomainProto;

public abstract class AnomalyInfo
implements OutputInfo<Event> {
    private static final long serialVersionUID = 1L;
    private static final Set<Event> DOMAIN = AnomalyInfo.makeDomain();
    @ProtoSerializableField
    protected long expectedCount = 0L;
    @ProtoSerializableField
    protected long anomalyCount = 0L;
    @ProtoSerializableField
    protected int unknownCount = 0;

    protected AnomalyInfo() {
    }

    protected AnomalyInfo(AnomalyInfo other) {
        this.expectedCount = other.expectedCount;
        this.anomalyCount = other.anomalyCount;
        this.unknownCount = other.unknownCount;
    }

    protected AnomalyInfo(long expectedCount, long anomalyCount, int unknownCount) {
        if (expectedCount < 0L) {
            throw new IllegalStateException("Invalid expectedCount, found " + expectedCount);
        }
        if (anomalyCount < 0L) {
            throw new IllegalStateException("Invalid anomalyCount, found " + anomalyCount);
        }
        if (unknownCount < 0) {
            throw new IllegalStateException("Invalid unknownCount, found " + unknownCount);
        }
        this.expectedCount = expectedCount;
        this.anomalyCount = anomalyCount;
        this.unknownCount = unknownCount;
    }

    public OutputDomainProto serialize() {
        return (OutputDomainProto)ProtoUtil.serialize((ProtoSerializable)this);
    }

    public int getUnknownCount() {
        return this.unknownCount;
    }

    public long getAnomalyCount() {
        return this.anomalyCount;
    }

    public long getExpectedCount() {
        return this.expectedCount;
    }

    public Set<Event> getDomain() {
        return DOMAIN;
    }

    public long getEventCount(Event.EventType type) {
        switch (type) {
            case ANOMALOUS: {
                return this.anomalyCount;
            }
            case EXPECTED: {
                return this.expectedCount;
            }
            case UNKNOWN: {
                return this.unknownCount;
            }
        }
        return 0L;
    }

    public Iterable<Pair<String, Long>> outputCountsIterable() {
        ArrayList<Pair<String, Long>> list = new ArrayList<Pair<String, Long>>();
        list.add(new Pair((Object)Event.EventType.ANOMALOUS.toString(), (Object)this.anomalyCount));
        list.add(new Pair((Object)Event.EventType.EXPECTED.toString(), (Object)this.expectedCount));
        return list;
    }

    public int size() {
        return DOMAIN.size();
    }

    public ImmutableOutputInfo<Event> generateImmutableOutputInfo() {
        return new ImmutableAnomalyInfo(this);
    }

    public MutableOutputInfo<Event> generateMutableOutputInfo() {
        return new MutableAnomalyInfo(this);
    }

    public String toReadableString() {
        return "AnomalyInfo(anomalies=" + this.anomalyCount + ",expected=" + this.expectedCount + ",unknown=" + this.unknownCount + ")";
    }

    public String toString() {
        return this.toReadableString();
    }

    public abstract AnomalyInfo copy();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnomalyInfo that = (AnomalyInfo)o;
        return this.expectedCount == that.expectedCount && this.anomalyCount == that.anomalyCount && this.unknownCount == that.unknownCount;
    }

    public int hashCode() {
        return Objects.hash(this.expectedCount, this.anomalyCount, this.unknownCount);
    }

    private static Set<Event> makeDomain() {
        HashSet<Event> set = new HashSet<Event>();
        set.add(AnomalyFactory.EXPECTED_EVENT);
        set.add(AnomalyFactory.ANOMALOUS_EVENT);
        return Collections.unmodifiableSet(set);
    }
}

