/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.anomaly;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.Objects;
import org.tribuo.Output;
import org.tribuo.anomaly.protos.EventProto;
import org.tribuo.protos.core.OutputProto;

public final class Event
implements Output<Event> {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_SCORE = Double.NaN;
    private final EventType type;
    private final double score;

    public Event(EventType type, double score) {
        this.type = type;
        this.score = score;
    }

    public Event(EventType type) {
        this(type, Double.NaN);
    }

    private Event(int type, double score) {
        EventType[] values = EventType.values();
        EventType eventEnum = null;
        for (EventType t : values) {
            if (t.getID() != type) continue;
            eventEnum = t;
        }
        if (eventEnum == null) {
            throw new IllegalStateException("Invalid EventType enum value, found " + type);
        }
        this.type = eventEnum;
        this.score = score;
    }

    public static Event deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        EventProto proto = (EventProto)message.unpack(EventProto.class);
        Event event = new Event(proto.getEvent().getNumber(), proto.getScore());
        return event;
    }

    public OutputProto serialize() {
        OutputProto.Builder builder = OutputProto.newBuilder();
        builder.setClassName(Event.class.getName());
        builder.setVersion(0);
        EventProto.Builder eventBuilder = EventProto.newBuilder();
        eventBuilder.setEventValue(this.type.value);
        eventBuilder.setScore(this.score);
        builder.setSerializedData(Any.pack((Message)eventBuilder.build()));
        return builder.build();
    }

    public double getScore() {
        return this.score;
    }

    public EventType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        return this.type == event.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public boolean fullEquals(Event o) {
        return this.fullEquals(o, 0.0);
    }

    public boolean fullEquals(Event o, double tolerance) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (Double.isNaN(o.score) ^ Double.isNaN(this.score)) {
            return false;
        }
        if (Math.abs(o.score - this.score) > tolerance) {
            return false;
        }
        return Objects.equals((Object)this.type, (Object)o.type);
    }

    public String toString() {
        if (Double.isNaN(this.score)) {
            return this.type.toString();
        }
        return "(" + this.type.toString() + "," + this.score + ")";
    }

    public Event copy() {
        return new Event(this.type, this.score);
    }

    public String getSerializableForm(boolean includeConfidence) {
        if (includeConfidence && !Double.isNaN(this.score)) {
            return this.type.toString() + ",score=" + this.score;
        }
        return this.type.toString();
    }

    public static enum EventType {
        ANOMALOUS(1),
        EXPECTED(0),
        UNKNOWN(-1);

        private final int value;

        private EventType(int value) {
            this.value = value;
        }

        protected int getID() {
            return this.value;
        }
    }
}

