/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client;

import io.lucenia.client.ResponseException;
import io.lucenia.client.ResponseWarningsExtractor;
import java.util.List;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StreamingResponse<T> {
    private final RequestLine requestLine;
    private final Mono<Message<HttpResponse, Publisher<T>>> publisher;
    private volatile HttpHost host;

    public StreamingResponse(RequestLine requestLine, Publisher<Message<HttpResponse, Publisher<T>>> publisher) {
        this.requestLine = requestLine;
        this.publisher = Mono.from(publisher).cache();
    }

    public void setHost(HttpHost host) {
        this.host = host;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public Publisher<T> getBody() {
        return this.publisher.flatMapMany(m -> Flux.from((Publisher)((Publisher)m.getBody())));
    }

    public StatusLine getStatusLine() {
        return new StatusLine((HttpResponse)this.publisher.map(Message::getHead).onErrorResume(ResponseException.class, e -> Mono.just((Object)e.getResponse().getHttpResponse())).block());
    }

    public List<String> getWarnings() {
        return ResponseWarningsExtractor.getWarnings((HttpResponse)this.publisher.map(Message::getHead).onErrorResume(ResponseException.class, e -> Mono.just((Object)e.getResponse().getHttpResponse())).block());
    }
}

