/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.nio;

import io.lucenia.client.nio.HeapBufferedAsyncEntityConsumer;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.AbstractAsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;

public class HeapBufferedAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<ClassicHttpResponse, byte[]> {
    private static final Log LOGGER = LogFactory.getLog(HeapBufferedAsyncResponseConsumer.class);
    private final int bufferLimit;

    public HeapBufferedAsyncResponseConsumer(int bufferLimit) {
        super((AsyncEntityConsumer)new HeapBufferedAsyncEntityConsumer(bufferLimit));
        this.bufferLimit = bufferLimit;
    }

    public int getBufferLimit() {
        return this.bufferLimit;
    }

    public void informationResponse(HttpResponse response, HttpContext context) throws HttpException, IOException {
    }

    protected ClassicHttpResponse buildResult(HttpResponse response, byte[] entity, ContentType contentType) {
        BasicClassicHttpResponse classicResponse = new BasicClassicHttpResponse(response.getCode());
        classicResponse.setVersion(response.getVersion());
        classicResponse.setHeaders(response.getHeaders());
        classicResponse.setReasonPhrase(response.getReasonPhrase());
        if (response.getLocale() != null) {
            classicResponse.setLocale(response.getLocale());
        }
        if (entity != null) {
            String encoding = null;
            try {
                Header contentEncoding = response.getHeader("Content-Encoding");
                if (contentEncoding != null) {
                    encoding = contentEncoding.getValue();
                }
            }
            catch (HttpException ex) {
                LOGGER.debug((Object)"Unable to detect content encoding", (Throwable)ex);
            }
            ByteArrayEntity httpEntity = new ByteArrayEntity(entity, contentType, encoding);
            classicResponse.setEntity((HttpEntity)httpEntity);
        }
        return classicResponse;
    }
}

