/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.client.secure;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;

public class TrustStore {
    private final String effectiveKeyAlias = "al";
    private final String storeType = "JKS";
    private final String certType = "X.509";
    private final String cert;

    public TrustStore(String file) {
        this.cert = file;
    }

    public KeyStore createKeyStore() throws IOException, GeneralSecurityException {
        X509Certificate[] trustCerts = this.loadCertificatesFromFile(this.cert);
        return this.toKeyStore("al", trustCerts);
    }

    private X509Certificate[] loadCertificatesFromFile(String file) throws IOException, GeneralSecurityException {
        if (file == null) {
            return null;
        }
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        try (InputStream is = Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);){
            Collection<? extends Certificate> certs = fact.generateCertificates(is);
            X509Certificate[] x509Certs = new X509Certificate[certs.size()];
            int i = 0;
            for (Certificate certificate : certs) {
                x509Certs[i++] = (X509Certificate)certificate;
            }
            X509Certificate[] x509CertificateArray = x509Certs;
            return x509CertificateArray;
        }
    }

    private KeyStore toKeyStore(String trustCertificatesAliasPrefix, X509Certificate[] trustCertificates) throws IOException, GeneralSecurityException {
        if (trustCertificates == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        if (trustCertificates != null) {
            for (int i = 0; i < trustCertificates.length; ++i) {
                X509Certificate x509Certificate = trustCertificates[i];
                ks.setCertificateEntry(trustCertificatesAliasPrefix + "_" + i, x509Certificate);
            }
        }
        return ks;
    }
}

