/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.search.aggregations.matrix.stats;

import io.lucenia.search.aggregations.matrix.stats.MatrixStatsAggregator;
import io.lucenia.search.aggregations.support.ArrayValuesSourceAggregatorFactory;
import io.skylite.core.aggregations.AggregationContext;
import io.skylite.core.aggregations.AggregationExecutionException;
import io.skylite.core.aggregations.Aggregator;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.aggregations.AggregatorFactory;
import io.skylite.core.aggregations.CardinalityUpperBound;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.aggregations.values.ValuesSourceConfig;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.internal.SearchExecutionContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class MatrixStatsAggregatorFactory
extends ArrayValuesSourceAggregatorFactory {
    private final MultiValueMode multiValueMode;

    MatrixStatsAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, MultiValueMode multiValueMode, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, context, parent, subFactoriesBuilder, metadata);
        this.multiValueMode = multiValueMode;
    }

    @Override
    protected Aggregator createUnmapped(SearchExecutionContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new MatrixStatsAggregator(this.name, null, searchContext, parent, this.multiValueMode, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Map<String, ValuesSource> valuesSources, SearchExecutionContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        HashMap<String, NumericValuesSource> typedValuesSources = new HashMap<String, NumericValuesSource>(valuesSources.size());
        for (Map.Entry<String, ValuesSource> entry : valuesSources.entrySet()) {
            if (!(entry.getValue() instanceof NumericValuesSource)) {
                throw new AggregationExecutionException("ValuesSource type " + entry.getValue().toString() + "is not supported for aggregation " + this.name());
            }
            typedValuesSources.put(entry.getKey(), (NumericValuesSource)entry.getValue());
        }
        return new MatrixStatsAggregator(this.name, typedValuesSources, searchContext, parent, this.multiValueMode, metadata);
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return true;
    }
}

