/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.search.aggregations.support;

import io.skylite.core.aggregations.values.BytesValuesSource;
import io.skylite.core.aggregations.values.NumericValuesSource;
import io.skylite.core.aggregations.values.ValuesSource;
import io.skylite.core.index.fielddata.NumericDoubleValues;
import io.skylite.core.search.MultiValueMode;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;

public abstract class ArrayValuesSource<VS extends ValuesSource> {
    protected MultiValueMode multiValueMode;
    protected String[] names;
    protected VS[] values;

    private ArrayValuesSource(Map<String, ?> valuesSources, MultiValueMode multiValueMode) {
        if (valuesSources != null) {
            this.names = valuesSources.keySet().toArray(new String[0]);
        }
        this.multiValueMode = multiValueMode;
    }

    public boolean needsScores() {
        boolean needsScores = false;
        for (VS value : this.values) {
            needsScores |= value.needsScores();
        }
        return needsScores;
    }

    public String[] fieldNames() {
        return this.names;
    }

    public static class GeoPointValuesSource
    extends ArrayValuesSource<io.skylite.core.aggregations.values.GeoPointValuesSource> {
        public GeoPointValuesSource(Map<String, io.skylite.core.aggregations.values.GeoPointValuesSource> valuesSources, MultiValueMode multiValueMode) {
            super(valuesSources, multiValueMode);
            this.values = (ValuesSource[])valuesSources.values().toArray(new io.skylite.core.aggregations.values.GeoPointValuesSource[0]);
        }
    }

    public static class BytesArrayValuesSource
    extends ArrayValuesSource<BytesValuesSource> {
        public BytesArrayValuesSource(Map<String, BytesValuesSource> valuesSources, MultiValueMode multiValueMode) {
            super(valuesSources, multiValueMode);
            this.values = (ValuesSource[])valuesSources.values().toArray(new BytesValuesSource[0]);
        }

        public Object getField(int ordinal, LeafReaderContext ctx) throws IOException {
            return ((BytesValuesSource[])this.values)[ordinal].bytesValues(ctx);
        }
    }

    public static class NumericArrayValuesSource
    extends ArrayValuesSource<NumericValuesSource> {
        public NumericArrayValuesSource(Map<String, NumericValuesSource> valuesSources, MultiValueMode multiValueMode) {
            super(valuesSources, multiValueMode);
            this.values = valuesSources != null ? (ValuesSource[])valuesSources.values().toArray(new NumericValuesSource[0]) : new NumericValuesSource[0];
        }

        public NumericDoubleValues getField(int ordinal, LeafReaderContext ctx) throws IOException {
            if (ordinal > this.names.length) {
                throw new IndexOutOfBoundsException("ValuesSource array index " + ordinal + " out of bounds");
            }
            return this.multiValueMode.select(((NumericValuesSource[])this.values)[ordinal].doubleValues(ctx));
        }
    }
}

