/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common;

import io.lucenia.ml.common.MLCommonsExtension;
import io.lucenia.ml.common.action.agents.DeleteAgentTransportAction;
import io.lucenia.ml.common.action.agents.GetAgentTransportAction;
import io.lucenia.ml.common.action.agents.TransportRegisterAgentAction;
import io.lucenia.ml.common.action.agents.TransportSearchAgentAction;
import io.lucenia.ml.common.action.batch.TransportBatchIngestionAction;
import io.lucenia.ml.common.action.config.GetConfigTransportAction;
import io.lucenia.ml.common.action.connector.DeleteConnectorTransportAction;
import io.lucenia.ml.common.action.connector.ExecuteConnectorTransportAction;
import io.lucenia.ml.common.action.connector.GetConnectorTransportAction;
import io.lucenia.ml.common.action.connector.SearchConnectorTransportAction;
import io.lucenia.ml.common.action.connector.TransportCreateConnectorAction;
import io.lucenia.ml.common.action.connector.UpdateConnectorTransportAction;
import io.lucenia.ml.common.action.controller.CreateControllerTransportAction;
import io.lucenia.ml.common.action.controller.DeleteControllerTransportAction;
import io.lucenia.ml.common.action.controller.DeployControllerTransportAction;
import io.lucenia.ml.common.action.controller.GetControllerTransportAction;
import io.lucenia.ml.common.action.controller.UndeployControllerTransportAction;
import io.lucenia.ml.common.action.controller.UpdateControllerTransportAction;
import io.lucenia.ml.common.action.deploy.TransportDeployModelAction;
import io.lucenia.ml.common.action.deploy.TransportDeployModelOnNodeAction;
import io.lucenia.ml.common.action.execute.TransportExecuteTaskAction;
import io.lucenia.ml.common.action.forward.TransportForwardAction;
import io.lucenia.ml.common.action.handler.MLSearchHandler;
import io.lucenia.ml.common.action.mcpserver.McpStatelessServerHolder;
import io.lucenia.ml.common.action.mcpserver.McpToolsHelper;
import io.lucenia.ml.common.action.mcpserver.TransportMcpServerAction;
import io.lucenia.ml.common.action.mcpserver.TransportMcpToolsListAction;
import io.lucenia.ml.common.action.mcpserver.TransportMcpToolsRegisterAction;
import io.lucenia.ml.common.action.mcpserver.TransportMcpToolsRegisterOnNodesAction;
import io.lucenia.ml.common.action.mcpserver.TransportMcpToolsRemoveAction;
import io.lucenia.ml.common.action.mcpserver.TransportMcpToolsRemoveOnNodesAction;
import io.lucenia.ml.common.action.mcpserver.TransportMcpToolsUpdateAction;
import io.lucenia.ml.common.action.mcpserver.TransportMcpToolsUpdateOnNodesAction;
import io.lucenia.ml.common.action.memory.conversation.CreateConversationAction;
import io.lucenia.ml.common.action.memory.conversation.CreateConversationTransportAction;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionAction;
import io.lucenia.ml.common.action.memory.conversation.CreateInteractionTransportAction;
import io.lucenia.ml.common.action.memory.conversation.DeleteConversationAction;
import io.lucenia.ml.common.action.memory.conversation.DeleteConversationTransportAction;
import io.lucenia.ml.common.action.memory.conversation.GetConversationAction;
import io.lucenia.ml.common.action.memory.conversation.GetConversationTransportAction;
import io.lucenia.ml.common.action.memory.conversation.GetConversationsAction;
import io.lucenia.ml.common.action.memory.conversation.GetConversationsTransportAction;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionAction;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionTransportAction;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionsAction;
import io.lucenia.ml.common.action.memory.conversation.GetInteractionsTransportAction;
import io.lucenia.ml.common.action.memory.conversation.GetTracesAction;
import io.lucenia.ml.common.action.memory.conversation.GetTracesTransportAction;
import io.lucenia.ml.common.action.memory.conversation.SearchConversationsAction;
import io.lucenia.ml.common.action.memory.conversation.SearchConversationsTransportAction;
import io.lucenia.ml.common.action.memory.conversation.SearchInteractionsAction;
import io.lucenia.ml.common.action.memory.conversation.SearchInteractionsTransportAction;
import io.lucenia.ml.common.action.memory.conversation.UpdateConversationAction;
import io.lucenia.ml.common.action.memory.conversation.UpdateConversationTransportAction;
import io.lucenia.ml.common.action.memory.conversation.UpdateInteractionAction;
import io.lucenia.ml.common.action.memory.conversation.UpdateInteractionTransportAction;
import io.lucenia.ml.common.action.model_group.DeleteModelGroupTransportAction;
import io.lucenia.ml.common.action.model_group.GetModelGroupTransportAction;
import io.lucenia.ml.common.action.model_group.SearchModelGroupTransportAction;
import io.lucenia.ml.common.action.model_group.TransportRegisterModelGroupAction;
import io.lucenia.ml.common.action.model_group.TransportUpdateModelGroupAction;
import io.lucenia.ml.common.action.models.DeleteModelTransportAction;
import io.lucenia.ml.common.action.models.GetModelTransportAction;
import io.lucenia.ml.common.action.models.SearchModelTransportAction;
import io.lucenia.ml.common.action.models.UpdateModelTransportAction;
import io.lucenia.ml.common.action.prediction.TransportPredictionTaskAction;
import io.lucenia.ml.common.action.profile.MLProfileAction;
import io.lucenia.ml.common.action.profile.MLProfileTransportAction;
import io.lucenia.ml.common.action.register.TransportRegisterModelAction;
import io.lucenia.ml.common.action.stats.MLStatsNodesAction;
import io.lucenia.ml.common.action.stats.MLStatsNodesTransportAction;
import io.lucenia.ml.common.action.syncup.TransportSyncUpOnNodeAction;
import io.lucenia.ml.common.action.tasks.CancelBatchJobTransportAction;
import io.lucenia.ml.common.action.tasks.DeleteTaskTransportAction;
import io.lucenia.ml.common.action.tasks.GetTaskTransportAction;
import io.lucenia.ml.common.action.tasks.SearchTaskTransportAction;
import io.lucenia.ml.common.action.tools.GetToolTransportAction;
import io.lucenia.ml.common.action.tools.ListToolsTransportAction;
import io.lucenia.ml.common.action.training.TransportTrainingTaskAction;
import io.lucenia.ml.common.action.trainpredict.TransportTrainAndPredictionTaskAction;
import io.lucenia.ml.common.action.undeploy.TransportUndeployModelAction;
import io.lucenia.ml.common.action.undeploy.TransportUndeployModelsAction;
import io.lucenia.ml.common.action.update_cache.UpdateModelCacheTransportAction;
import io.lucenia.ml.common.action.upload_chunk.MLModelChunkUploader;
import io.lucenia.ml.common.action.upload_chunk.TransportRegisterModelMetaAction;
import io.lucenia.ml.common.action.upload_chunk.TransportUploadModelChunkAction;
import io.lucenia.ml.common.autoredeploy.MLModelAutoReDeployer;
import io.lucenia.ml.common.cluster.MLCommonsClusterEventListener;
import io.lucenia.ml.common.cluster.MLCommonsClusterManagerEventListener;
import io.lucenia.ml.common.conversation.ConversationMetaIndex;
import io.lucenia.ml.common.conversation.ConversationalSearchService;
import io.lucenia.ml.common.engine.algorithms.agent.MLAgentExecutor;
import io.lucenia.ml.common.engine.algorithms.anomalylocalization.AnomalyLocalizerImpl;
import io.lucenia.ml.common.engine.algorithms.metrics_correlation.MetricsCorrelation;
import io.lucenia.ml.common.engine.algorithms.sample.LocalSampleCalculator;
import io.lucenia.ml.common.engine.encryptors.AWSEncryptorImpl;
import io.lucenia.ml.common.engine.indices.MLInputDatasetHandler;
import io.lucenia.ml.common.engine.memory.ConversationIndexMemory;
import io.lucenia.ml.common.engine.memory.MLMemoryManager;
import io.lucenia.ml.common.engine.systemindices.MLIndicesHandler;
import io.lucenia.ml.common.engine.tools.AgentTool;
import io.lucenia.ml.common.engine.tools.CatIndexTool;
import io.lucenia.ml.common.engine.tools.ConnectorTool;
import io.lucenia.ml.common.engine.tools.IndexMappingTool;
import io.lucenia.ml.common.engine.tools.ListIndexTool;
import io.lucenia.ml.common.engine.tools.MLModelTool;
import io.lucenia.ml.common.engine.tools.SearchIndexTool;
import io.lucenia.ml.common.engine.tools.VisualizationsTool;
import io.lucenia.ml.common.helpers.ConnectorAccessControlHelper;
import io.lucenia.ml.common.input.execute.anomalylocalization.AnomalyLocalizationInput;
import io.lucenia.ml.common.jobs.MLBatchTaskUpdateJobRunner;
import io.lucenia.ml.common.model.AgentModelsSearcher;
import io.lucenia.ml.common.model.MLModelManager;
import io.lucenia.ml.common.model.ModelAccessControlHelper;
import io.lucenia.ml.common.processor.MLInferenceIngestProcessor;
import io.lucenia.ml.common.processor.MLInferenceSearchRequestProcessor;
import io.lucenia.ml.common.processor.MLInferenceSearchResponseProcessor;
import io.lucenia.ml.common.rest.RestMLBatchIngestAction;
import io.lucenia.ml.common.rest.RestMLCancelBatchJobAction;
import io.lucenia.ml.common.rest.RestMLCreateConnectorAction;
import io.lucenia.ml.common.rest.RestMLCreateControllerAction;
import io.lucenia.ml.common.rest.RestMLDeleteAgentAction;
import io.lucenia.ml.common.rest.RestMLDeleteConnectorAction;
import io.lucenia.ml.common.rest.RestMLDeleteControllerAction;
import io.lucenia.ml.common.rest.RestMLDeleteModelAction;
import io.lucenia.ml.common.rest.RestMLDeleteModelGroupAction;
import io.lucenia.ml.common.rest.RestMLDeleteTaskAction;
import io.lucenia.ml.common.rest.RestMLDeployModelAction;
import io.lucenia.ml.common.rest.RestMLExecuteAction;
import io.lucenia.ml.common.rest.RestMLGetAgentAction;
import io.lucenia.ml.common.rest.RestMLGetConfigAction;
import io.lucenia.ml.common.rest.RestMLGetConnectorAction;
import io.lucenia.ml.common.rest.RestMLGetControllerAction;
import io.lucenia.ml.common.rest.RestMLGetModelAction;
import io.lucenia.ml.common.rest.RestMLGetModelGroupAction;
import io.lucenia.ml.common.rest.RestMLGetTaskAction;
import io.lucenia.ml.common.rest.RestMLGetToolAction;
import io.lucenia.ml.common.rest.RestMLListToolsAction;
import io.lucenia.ml.common.rest.RestMLPredictionAction;
import io.lucenia.ml.common.rest.RestMLProfileAction;
import io.lucenia.ml.common.rest.RestMLRegisterAgentAction;
import io.lucenia.ml.common.rest.RestMLRegisterModelAction;
import io.lucenia.ml.common.rest.RestMLRegisterModelGroupAction;
import io.lucenia.ml.common.rest.RestMLRegisterModelMetaAction;
import io.lucenia.ml.common.rest.RestMLSearchAgentAction;
import io.lucenia.ml.common.rest.RestMLSearchConnectorAction;
import io.lucenia.ml.common.rest.RestMLSearchModelAction;
import io.lucenia.ml.common.rest.RestMLSearchModelGroupAction;
import io.lucenia.ml.common.rest.RestMLSearchTaskAction;
import io.lucenia.ml.common.rest.RestMLStatsAction;
import io.lucenia.ml.common.rest.RestMLTrainAndPredictAction;
import io.lucenia.ml.common.rest.RestMLTrainingAction;
import io.lucenia.ml.common.rest.RestMLUndeployModelAction;
import io.lucenia.ml.common.rest.RestMLUpdateConnectorAction;
import io.lucenia.ml.common.rest.RestMLUpdateControllerAction;
import io.lucenia.ml.common.rest.RestMLUpdateModelAction;
import io.lucenia.ml.common.rest.RestMLUpdateModelGroupAction;
import io.lucenia.ml.common.rest.RestMLUploadModelChunkAction;
import io.lucenia.ml.common.rest.RestMemoryCreateConversationAction;
import io.lucenia.ml.common.rest.RestMemoryCreateInteractionAction;
import io.lucenia.ml.common.rest.RestMemoryDeleteConversationAction;
import io.lucenia.ml.common.rest.RestMemoryGetConversationAction;
import io.lucenia.ml.common.rest.RestMemoryGetConversationsAction;
import io.lucenia.ml.common.rest.RestMemoryGetInteractionAction;
import io.lucenia.ml.common.rest.RestMemoryGetInteractionsAction;
import io.lucenia.ml.common.rest.RestMemoryGetTracesAction;
import io.lucenia.ml.common.rest.RestMemorySearchConversationsAction;
import io.lucenia.ml.common.rest.RestMemorySearchInteractionsAction;
import io.lucenia.ml.common.rest.RestMemoryUpdateConversationAction;
import io.lucenia.ml.common.rest.RestMemoryUpdateInteractionAction;
import io.lucenia.ml.common.rest.mcpserver.RestMLMcpToolsListAction;
import io.lucenia.ml.common.rest.mcpserver.RestMLMcpToolsRegisterAction;
import io.lucenia.ml.common.rest.mcpserver.RestMLMcpToolsRemoveAction;
import io.lucenia.ml.common.rest.mcpserver.RestMLMcpToolsUpdateAction;
import io.lucenia.ml.common.rest.mcpserver.RestMcpServerAction;
import io.lucenia.ml.common.rest.mcpserver.ToolFactoryWrapper;
import io.lucenia.ml.common.search.pipelines.generative.GenerativeQARequestProcessor;
import io.lucenia.ml.common.search.pipelines.generative.GenerativeQAResponseProcessor;
import io.lucenia.ml.common.task.MLExecuteTaskRunner;
import io.lucenia.ml.common.task.MLPredictTaskRunner;
import io.lucenia.ml.common.task.MLTaskDispatcher;
import io.lucenia.ml.common.task.MLTaskManager;
import io.lucenia.ml.common.task.MLTrainAndPredictTaskRunner;
import io.lucenia.ml.common.task.MLTrainingTaskRunner;
import io.lucenia.ml.common.transport.agent.MLSearchAgentAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpServerAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsListAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsRegisterAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsRegisterOnNodesAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsRemoveAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsRemoveOnNodesAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsUpdateAction;
import io.lucenia.ml.common.transport.mcpserver.action.MLMcpToolsUpdateOnNodesAction;
import io.lucenia.ml.common.utils.IndexUtils;
import io.lucenia.plugins.ActionPlugin;
import io.lucenia.plugins.ExtensiblePlugin;
import io.lucenia.plugins.Plugin;
import io.lucenia.plugins.SearchPlugin;
import io.lucenia.plugins.SystemIndexPlugin;
import io.skylite.common.processor.AbstractProcessor;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.Client;
import io.skylite.core.client.ReleasableSkyliteClient;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.MetadataClientFactory;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.env.Environment;
import io.skylite.core.env.NodeEnvironment;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.ingest.IngestProcessor;
import io.skylite.core.monitor.jvm.JvmService;
import io.skylite.core.monitor.os.OsService;
import io.skylite.core.plugins.IngestPlugin;
import io.skylite.core.plugins.SearchPipelinePlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.pipeline.SearchProcessor;
import io.skylite.core.search.pipeline.SearchRequestProcessor;
import io.skylite.core.search.pipeline.SearchResponseProcessor;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ExecutorBuilder;
import io.skylite.core.threadpool.FixedExecutorBuilder;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.ml.common.FunctionName;
import io.skylite.ml.common.breaker.MLCircuitBreakerService;
import io.skylite.ml.common.cluster.DiscoveryNodeHelper;
import io.skylite.ml.common.conversation.ConversationalMemoryHandler;
import io.skylite.ml.common.engine.Encryptor;
import io.skylite.ml.common.engine.MLEngine;
import io.skylite.ml.common.engine.MLEngineClassLoader;
import io.skylite.ml.common.engine.ModelDownloader;
import io.skylite.ml.common.engine.memory.Memory;
import io.skylite.ml.common.engine.tools.Tool;
import io.skylite.ml.common.engine.tools.ToolAnnotation;
import io.skylite.ml.common.input.execute.metricscorrelation.MetricsCorrelationInput;
import io.skylite.ml.common.input.execute.samplecalculator.LocalSampleCalculatorInput;
import io.skylite.ml.common.input.parameter.ad.AnomalyDetectionLibSVMParams;
import io.skylite.ml.common.input.parameter.clustering.KMeansParams;
import io.skylite.ml.common.input.parameter.clustering.RCFSummarizeParams;
import io.skylite.ml.common.input.parameter.rcf.BatchRCFParams;
import io.skylite.ml.common.input.parameter.rcf.FitRCFParams;
import io.skylite.ml.common.input.parameter.regression.LinearRegressionParams;
import io.skylite.ml.common.input.parameter.regression.LogisticRegressionParams;
import io.skylite.ml.common.input.parameter.sample.SampleAlgoParams;
import io.skylite.ml.common.input.parameter.textembedding.AsymmetricTextEmbeddingParameters;
import io.skylite.ml.common.model.MLModelCacheHelper;
import io.skylite.ml.common.model.TextEmbeddingModelConfig;
import io.skylite.ml.common.search.pipelines.generative.ext.GenerativeQAParamExtBuilder;
import io.skylite.ml.common.searchext.MLInferenceRequestParametersExtBuilder;
import io.skylite.ml.common.settings.MLCommonsSettings;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.stats.MLClusterLevelStat;
import io.skylite.ml.common.stats.MLNodeLevelStat;
import io.skylite.ml.common.stats.MLStat;
import io.skylite.ml.common.stats.MLStats;
import io.skylite.ml.common.stats.suppliers.CounterSupplier;
import io.skylite.ml.common.transport.agent.MLAgentDeleteAction;
import io.skylite.ml.common.transport.agent.MLAgentGetAction;
import io.skylite.ml.common.transport.agent.MLRegisterAgentAction;
import io.skylite.ml.common.transport.batch.MLBatchIngestionAction;
import io.skylite.ml.common.transport.config.MLConfigGetAction;
import io.skylite.ml.common.transport.connector.MLConnectorDeleteAction;
import io.skylite.ml.common.transport.connector.MLConnectorGetAction;
import io.skylite.ml.common.transport.connector.MLConnectorSearchAction;
import io.skylite.ml.common.transport.connector.MLCreateConnectorAction;
import io.skylite.ml.common.transport.connector.MLExecuteConnectorAction;
import io.skylite.ml.common.transport.connector.MLUpdateConnectorAction;
import io.skylite.ml.common.transport.controller.MLControllerDeleteAction;
import io.skylite.ml.common.transport.controller.MLControllerGetAction;
import io.skylite.ml.common.transport.controller.MLCreateControllerAction;
import io.skylite.ml.common.transport.controller.MLDeployControllerAction;
import io.skylite.ml.common.transport.controller.MLUndeployControllerAction;
import io.skylite.ml.common.transport.controller.MLUpdateControllerAction;
import io.skylite.ml.common.transport.deploy.MLDeployModelAction;
import io.skylite.ml.common.transport.deploy.MLDeployModelOnNodeAction;
import io.skylite.ml.common.transport.execute.MLExecuteTaskAction;
import io.skylite.ml.common.transport.forward.MLForwardAction;
import io.skylite.ml.common.transport.model.MLModelDeleteAction;
import io.skylite.ml.common.transport.model.MLModelGetAction;
import io.skylite.ml.common.transport.model.MLModelSearchAction;
import io.skylite.ml.common.transport.model.MLUpdateModelAction;
import io.skylite.ml.common.transport.model_group.MLModelGroupDeleteAction;
import io.skylite.ml.common.transport.model_group.MLModelGroupGetAction;
import io.skylite.ml.common.transport.model_group.MLModelGroupSearchAction;
import io.skylite.ml.common.transport.model_group.MLRegisterModelGroupAction;
import io.skylite.ml.common.transport.model_group.MLUpdateModelGroupAction;
import io.skylite.ml.common.transport.prediction.MLPredictionTaskAction;
import io.skylite.ml.common.transport.register.MLRegisterModelAction;
import io.skylite.ml.common.transport.sync.MLSyncUpAction;
import io.skylite.ml.common.transport.task.MLCancelBatchJobAction;
import io.skylite.ml.common.transport.task.MLTaskDeleteAction;
import io.skylite.ml.common.transport.task.MLTaskGetAction;
import io.skylite.ml.common.transport.task.MLTaskSearchAction;
import io.skylite.ml.common.transport.tools.MLGetToolAction;
import io.skylite.ml.common.transport.tools.MLListToolsAction;
import io.skylite.ml.common.transport.training.MLTrainingTaskAction;
import io.skylite.ml.common.transport.trainpredict.MLTrainAndPredictionTaskAction;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelAction;
import io.skylite.ml.common.transport.undeploy.MLUndeployModelsAction;
import io.skylite.ml.common.transport.update_cache.MLUpdateModelCacheAction;
import io.skylite.ml.common.transport.upload_chunk.MLRegisterModelMetaAction;
import io.skylite.ml.common.transport.upload_chunk.MLUploadModelChunkAction;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.RestController;
import org.opensearch.watcher.ResourceWatcherService;

public class MLModulePlugin
extends Plugin
implements ActionPlugin,
SearchPlugin,
SearchPipelinePlugin,
ExtensiblePlugin,
IngestPlugin,
SystemIndexPlugin {
    private static final Logger log = LogManager.getLogger(MLModulePlugin.class);
    private MLStats mlStats;
    private MLModelCacheHelper modelCacheHelper;
    private MLTaskManager mlTaskManager;
    private MLModelManager mlModelManager;
    private MLIndicesHandler mlIndicesHandler;
    private MLInputDatasetHandler mlInputDatasetHandler;
    private MLTrainingTaskRunner mlTrainingTaskRunner;
    private MLPredictTaskRunner mlPredictTaskRunner;
    private MLTrainAndPredictTaskRunner mlTrainAndPredictTaskRunner;
    private MLExecuteTaskRunner mlExecuteTaskRunner;
    private IndexUtils indexUtils;
    private ModelDownloader mlModelDownloader;
    private DiscoveryNodeHelper nodeHelper;
    private AgentModelsSearcher agentModelsSearcher;
    private MLModelChunkUploader mlModelChunkUploader;
    private MLEngine mlEngine;
    private Client client;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Set<String> indicesToListen;
    public static final String ML_ROLE_NAME = "ml";
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;
    private ConnectorAccessControlHelper connectorAccessControlHelper;
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private ConversationalMemoryHandler cmHandler;
    private volatile boolean ragSearchPipelineEnabled;
    private McpToolsHelper mcpToolsHelper;
    private McpStatelessServerHolder statelessServerHolder;
    Map<String, Tool.Factory<?>> externalToolFactories;
    private Map<String, Tool.Factory<?>> toolFactories;
    private ScriptService scriptService;
    private Encryptor encryptor;

    public MLModulePlugin(Settings settings) {
        this.ragSearchPipelineEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_RAG_PIPELINE_FEATURE_ENABLED.get(settings);
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)MLStatsNodesAction.INSTANCE, MLStatsNodesTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLExecuteTaskAction.INSTANCE, TransportExecuteTaskAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLPredictionTaskAction.INSTANCE, TransportPredictionTaskAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLTrainingTaskAction.INSTANCE, TransportTrainingTaskAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLTrainAndPredictionTaskAction.INSTANCE, TransportTrainAndPredictionTaskAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelGetAction.INSTANCE, GetModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelDeleteAction.INSTANCE, DeleteModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelSearchAction.INSTANCE, SearchModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLTaskGetAction.INSTANCE, GetTaskTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLTaskDeleteAction.INSTANCE, DeleteTaskTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLTaskSearchAction.INSTANCE, SearchTaskTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLProfileAction.INSTANCE, MLProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLRegisterModelAction.INSTANCE, TransportRegisterModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLDeployModelAction.INSTANCE, TransportDeployModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLDeployModelOnNodeAction.INSTANCE, TransportDeployModelOnNodeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUndeployModelAction.INSTANCE, TransportUndeployModelAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUndeployModelsAction.INSTANCE, TransportUndeployModelsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLRegisterModelMetaAction.INSTANCE, TransportRegisterModelMetaAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUploadModelChunkAction.INSTANCE, TransportUploadModelChunkAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUpdateModelAction.INSTANCE, UpdateModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUpdateModelCacheAction.INSTANCE, UpdateModelCacheTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLForwardAction.INSTANCE, TransportForwardAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLSyncUpAction.INSTANCE, TransportSyncUpOnNodeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLRegisterModelGroupAction.INSTANCE, TransportRegisterModelGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUpdateModelGroupAction.INSTANCE, TransportUpdateModelGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelGroupGetAction.INSTANCE, GetModelGroupTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelGroupSearchAction.INSTANCE, SearchModelGroupTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLModelGroupDeleteAction.INSTANCE, DeleteModelGroupTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLCreateConnectorAction.INSTANCE, TransportCreateConnectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLExecuteConnectorAction.INSTANCE, ExecuteConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLConnectorGetAction.INSTANCE, GetConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLConnectorDeleteAction.INSTANCE, DeleteConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLConnectorSearchAction.INSTANCE, SearchConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateConversationAction.INSTANCE, CreateConversationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetConversationsAction.INSTANCE, GetConversationsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateInteractionAction.INSTANCE, CreateInteractionTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetInteractionsAction.INSTANCE, GetInteractionsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteConversationAction.INSTANCE, DeleteConversationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUpdateConnectorAction.INSTANCE, UpdateConnectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLRegisterAgentAction.INSTANCE, TransportRegisterAgentAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLSearchAgentAction.INSTANCE, TransportSearchAgentAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchInteractionsAction.INSTANCE, SearchInteractionsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchConversationsAction.INSTANCE, SearchConversationsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetConversationAction.INSTANCE, GetConversationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetInteractionAction.INSTANCE, GetInteractionTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLCreateControllerAction.INSTANCE, CreateControllerTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLControllerGetAction.INSTANCE, GetControllerTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLDeployControllerAction.INSTANCE, DeployControllerTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUpdateControllerAction.INSTANCE, UpdateControllerTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLControllerDeleteAction.INSTANCE, DeleteControllerTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLUndeployControllerAction.INSTANCE, UndeployControllerTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLAgentGetAction.INSTANCE, GetAgentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLAgentDeleteAction.INSTANCE, DeleteAgentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateConversationAction.INSTANCE, UpdateConversationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateInteractionAction.INSTANCE, UpdateInteractionTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTracesAction.INSTANCE, GetTracesTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLListToolsAction.INSTANCE, ListToolsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLGetToolAction.INSTANCE, GetToolTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLConfigGetAction.INSTANCE, GetConfigTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLBatchIngestionAction.INSTANCE, TransportBatchIngestionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLCancelBatchJobAction.INSTANCE, CancelBatchJobTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpToolsRegisterAction.INSTANCE, TransportMcpToolsRegisterAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpToolsRegisterOnNodesAction.INSTANCE, TransportMcpToolsRegisterOnNodesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpToolsListAction.INSTANCE, TransportMcpToolsListAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpToolsUpdateAction.INSTANCE, TransportMcpToolsUpdateAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpToolsUpdateOnNodesAction.INSTANCE, TransportMcpToolsUpdateOnNodesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpToolsRemoveAction.INSTANCE, TransportMcpToolsRemoveAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpToolsRemoveOnNodesAction.INSTANCE, TransportMcpToolsRemoveOnNodesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)MLMcpServerAction.INSTANCE, TransportMcpServerAction.class, new Class[0]));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        OsService osService;
        this.indexUtils = new IndexUtils(client, clusterService);
        this.client = client;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.scriptService = scriptService;
        Settings settings = environment.settings();
        Path dataPath = environment.dataFiles()[0];
        this.mlIndicesHandler = new MLIndicesHandler(clusterService, client);
        this.encryptor = new AWSEncryptorImpl(clusterService, client, this.mlIndicesHandler);
        MetadataClient metadataClient = MetadataClientFactory.createSdkClient((ReleasableSkyliteClient)client, (NamedXContentRegistry)xContentRegistry, (Boolean)MLCommonsSettings.ML_COMMONS_MULTI_TENANCY_ENABLED.get(settings) != false ? Map.ofEntries(Map.entry("remote_metadata_type", (String)MLCommonsSettings.REMOTE_METADATA_TYPE.get(settings)), Map.entry("remote_metadata_endpoint", (String)MLCommonsSettings.REMOTE_METADATA_ENDPOINT.get(settings)), Map.entry("remote_metadata_region", (String)MLCommonsSettings.REMOTE_METADATA_REGION.get(settings)), Map.entry("remote_metadata_service_name", (String)MLCommonsSettings.REMOTE_METADATA_SERVICE_NAME.get(settings)), Map.entry("tenant_aware", "true"), Map.entry("tenant_id", "tenant_id")) : Collections.emptyMap(), (Executor)client.threadPool().executor("generic"));
        this.mlEngine = new MLEngine(dataPath, this.encryptor);
        this.nodeHelper = new DiscoveryNodeHelper(clusterService, settings);
        this.modelCacheHelper = new MLModelCacheHelper(clusterService, settings);
        this.cmHandler = new ConversationalSearchService(client, clusterService);
        JvmService jvmService = new JvmService(environment.settings());
        try {
            osService = new OsService(environment.settings());
        }
        catch (IOException e) {
            log.error("Failed to initialize OsService in MLModule startup", (Throwable)e);
            throw new RuntimeException("Failed to initialize OsService", e);
        }
        MLCircuitBreakerService mlCircuitBreakerService = new MLCircuitBreakerService(jvmService, osService, settings, clusterService).init(dataPath);
        ConcurrentHashMap<Object, MLStat> stats = new ConcurrentHashMap<Object, MLStat>();
        stats.put(MLClusterLevelStat.ML_MODEL_INDEX_STATUS, new MLStat(true, (Supplier)new IndexUtils.IndexStatusSupplier(this.indexUtils, ".plugins-ml-model")));
        stats.put(MLClusterLevelStat.ML_CONNECTOR_INDEX_STATUS, new MLStat(true, (Supplier)new IndexUtils.IndexStatusSupplier(this.indexUtils, ".plugins-ml-connector")));
        stats.put(MLClusterLevelStat.ML_CONFIG_INDEX_STATUS, new MLStat(true, (Supplier)new IndexUtils.IndexStatusSupplier(this.indexUtils, ".plugins-ml-config")));
        stats.put(MLClusterLevelStat.ML_TASK_INDEX_STATUS, new MLStat(true, (Supplier)new IndexUtils.IndexStatusSupplier(this.indexUtils, ".plugins-ml-task")));
        stats.put(MLClusterLevelStat.ML_CONTROLLER_INDEX_STATUS, new MLStat(true, (Supplier)new IndexUtils.IndexStatusSupplier(this.indexUtils, ".plugins-ml-controller")));
        stats.put(MLClusterLevelStat.ML_MODEL_COUNT, new MLStat(true, (Supplier)new CounterSupplier()));
        stats.put(MLClusterLevelStat.ML_CONNECTOR_COUNT, new MLStat(true, (Supplier)new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_EXECUTING_TASK_COUNT, new MLStat(false, (Supplier)new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_REQUEST_COUNT, new MLStat(false, (Supplier)new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_FAILURE_COUNT, new MLStat(false, (Supplier)new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_DEPLOYED_MODEL_COUNT, new MLStat(false, (Supplier)new CounterSupplier()));
        stats.put(MLNodeLevelStat.ML_CIRCUIT_BREAKER_TRIGGER_COUNT, new MLStat(false, (Supplier)new CounterSupplier()));
        this.mlStats = new MLStats(stats);
        this.mlTaskManager = new MLTaskManager(client, metadataClient, threadPool, this.mlIndicesHandler);
        this.mlModelDownloader = new ModelDownloader();
        this.mlInputDatasetHandler = new MLInputDatasetHandler(client);
        this.modelAccessControlHelper = new ModelAccessControlHelper(clusterService, settings);
        this.connectorAccessControlHelper = new ConnectorAccessControlHelper(clusterService, settings);
        this.mlFeatureEnabledSetting = new MLFeatureEnabledSetting(clusterService, settings);
        this.mlModelManager = new MLModelManager(clusterService, scriptService, client, metadataClient, threadPool, xContentRegistry, this.mlModelDownloader, settings, this.mlStats, mlCircuitBreakerService, this.mlIndicesHandler, this.mlTaskManager, this.modelCacheHelper, this.mlEngine, this.nodeHelper, this.mlFeatureEnabledSetting);
        this.mlModelChunkUploader = new MLModelChunkUploader(this.mlIndicesHandler, client, xContentRegistry, this.modelAccessControlHelper);
        MLTaskDispatcher mlTaskDispatcher = new MLTaskDispatcher(clusterService, client, settings, this.nodeHelper);
        this.mlTrainingTaskRunner = new MLTrainingTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlIndicesHandler, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, this.nodeHelper, this.mlEngine);
        this.mlPredictTaskRunner = new MLPredictTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, xContentRegistry, this.mlModelManager, this.nodeHelper, this.mlEngine, settings);
        this.mlTrainAndPredictTaskRunner = new MLTrainAndPredictTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, this.nodeHelper, this.mlEngine);
        this.mlExecuteTaskRunner = new MLExecuteTaskRunner(threadPool, clusterService, client, this.mlTaskManager, this.mlStats, this.mlInputDatasetHandler, mlTaskDispatcher, mlCircuitBreakerService, this.nodeHelper, this.mlEngine);
        LocalSampleCalculator localSampleCalculator = new LocalSampleCalculator(client, settings);
        this.toolFactories = new HashMap();
        MLModelTool.Factory.getInstance().init(client);
        AgentTool.Factory.getInstance().init(client);
        CatIndexTool.Factory.getInstance().init(client, clusterService);
        IndexMappingTool.Factory.getInstance().init(client);
        ListIndexTool.Factory.getInstance().init(client, clusterService);
        SearchIndexTool.Factory.getInstance().init(client, xContentRegistry);
        VisualizationsTool.Factory.getInstance().init(client);
        ConnectorTool.Factory.getInstance().init(client);
        this.toolFactories.put("MLModelTool", (Tool.Factory<?>)MLModelTool.Factory.getInstance());
        this.toolFactories.put("AgentTool", AgentTool.Factory.getInstance());
        this.toolFactories.put("CatIndexTool", CatIndexTool.Factory.getInstance());
        this.toolFactories.put("IndexMappingTool", IndexMappingTool.Factory.getInstance());
        this.toolFactories.put("ListIndexTool", ListIndexTool.Factory.getInstance());
        this.toolFactories.put("SearchIndexTool", SearchIndexTool.Factory.getInstance());
        this.toolFactories.put("VisualizationTool", VisualizationsTool.Factory.getInstance());
        this.toolFactories.put("ConnectorTool", ConnectorTool.Factory.getInstance());
        if (this.externalToolFactories != null) {
            this.toolFactories.putAll(this.externalToolFactories);
        }
        this.agentModelsSearcher = new AgentModelsSearcher(this.toolFactories);
        MLMemoryManager memoryManager = new MLMemoryManager(client, clusterService, new ConversationMetaIndex(client, clusterService));
        HashMap<String, Memory.Factory> memoryFactoryMap = new HashMap<String, Memory.Factory>();
        ConversationIndexMemory.Factory conversationIndexMemoryFactory = new ConversationIndexMemory.Factory();
        conversationIndexMemoryFactory.init(client, this.mlIndicesHandler, memoryManager);
        memoryFactoryMap.put("conversation_index", conversationIndexMemoryFactory);
        MLAgentExecutor agentExecutor = new MLAgentExecutor(client, metadataClient, settings, clusterService, xContentRegistry, this.toolFactories, memoryFactoryMap, this.mlFeatureEnabledSetting.isMultiTenancyEnabled());
        MLEngineClassLoader.register((Enum)FunctionName.LOCAL_SAMPLE_CALCULATOR, (Object)localSampleCalculator);
        MLEngineClassLoader.register((Enum)FunctionName.AGENT, (Object)agentExecutor);
        AnomalyLocalizerImpl anomalyLocalizer = new AnomalyLocalizerImpl(client, settings, clusterService, indexNameExpressionResolver);
        MLEngineClassLoader.register((Enum)FunctionName.ANOMALY_LOCALIZATION, (Object)anomalyLocalizer);
        MetricsCorrelation metricsCorrelation = new MetricsCorrelation(client, settings, clusterService);
        MLEngineClassLoader.register((Enum)FunctionName.METRICS_CORRELATION, (Object)((Object)metricsCorrelation));
        MLEngineClassLoader.initializeFromPlugin((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        MLSearchHandler mlSearchHandler = new MLSearchHandler(client, xContentRegistry, this.modelAccessControlHelper, clusterService);
        MLModelAutoReDeployer mlModelAutoRedeployer = new MLModelAutoReDeployer(clusterService, client, settings, this.mlModelManager, new MLModelAutoReDeployer.SearchRequestBuilderFactory());
        MLCommonsClusterEventListener mlCommonsClusterEventListener = new MLCommonsClusterEventListener(clusterService, this.mlModelManager, this.mlTaskManager, this.modelCacheHelper, mlModelAutoRedeployer);
        MLCommonsClusterManagerEventListener clusterManagerEventListener = new MLCommonsClusterManagerEventListener(clusterService, client, metadataClient, settings, threadPool, this.nodeHelper, this.mlIndicesHandler, this.encryptor, mlModelAutoRedeployer, this.mlFeatureEnabledSetting);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_RAG_PIPELINE_FEATURE_ENABLED, it -> {
            this.ragSearchPipelineEnabled = it;
        });
        MLBatchTaskUpdateJobRunner.getJobRunnerInstance().initialize(clusterService, threadPool, client);
        ToolFactoryWrapper toolFactoryWrapper = new ToolFactoryWrapper(this.toolFactories);
        this.mcpToolsHelper = new McpToolsHelper(client, toolFactoryWrapper);
        this.statelessServerHolder = new McpStatelessServerHolder(this.mcpToolsHelper, client, threadPool);
        return Arrays.asList(this.encryptor, this.mlEngine, this.nodeHelper, this.modelCacheHelper, this.mlStats, this.mlTaskManager, this.mlModelManager, this.agentModelsSearcher, this.mlIndicesHandler, this.mlInputDatasetHandler, this.mlTrainingTaskRunner, this.mlPredictTaskRunner, this.mlTrainAndPredictTaskRunner, this.mlExecuteTaskRunner, this.modelAccessControlHelper, this.connectorAccessControlHelper, this.mlFeatureEnabledSetting, mlSearchHandler, mlTaskDispatcher, this.mlModelChunkUploader, this.mlModelDownloader, mlCommonsClusterEventListener, clusterManagerEventListener, mlCircuitBreakerService, mlModelAutoRedeployer, this.cmHandler, metadataClient, toolFactoryWrapper, this.mcpToolsHelper, this.statelessServerHolder);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestMLStatsAction restMLStatsAction = new RestMLStatsAction(this.mlStats, this.clusterService, this.indexUtils, this.xContentRegistry);
        RestMLTrainingAction restMLTrainingAction = new RestMLTrainingAction();
        RestMLTrainAndPredictAction restMLTrainAndPredictAction = new RestMLTrainAndPredictAction();
        RestMLPredictionAction restMLPredictionAction = new RestMLPredictionAction(this.mlModelManager, this.mlFeatureEnabledSetting);
        RestMLExecuteAction restMLExecuteAction = new RestMLExecuteAction(this.mlFeatureEnabledSetting);
        RestMLGetModelAction restMLGetModelAction = new RestMLGetModelAction(this.mlFeatureEnabledSetting);
        RestMLDeleteModelAction restMLDeleteModelAction = new RestMLDeleteModelAction(this.mlFeatureEnabledSetting);
        RestMLSearchModelAction restMLSearchModelAction = new RestMLSearchModelAction(this.mlFeatureEnabledSetting);
        RestMLGetTaskAction restMLGetTaskAction = new RestMLGetTaskAction(this.mlFeatureEnabledSetting);
        RestMLDeleteTaskAction restMLDeleteTaskAction = new RestMLDeleteTaskAction(this.mlFeatureEnabledSetting);
        RestMLSearchTaskAction restMLSearchTaskAction = new RestMLSearchTaskAction(this.mlFeatureEnabledSetting);
        RestMLProfileAction restMLProfileAction = new RestMLProfileAction(this.clusterService);
        RestMLRegisterModelAction restMLRegisterModelAction = new RestMLRegisterModelAction(this.clusterService, settings, this.mlFeatureEnabledSetting);
        RestMLRegisterAgentAction restMLRegisterAgentAction = new RestMLRegisterAgentAction(this.mlFeatureEnabledSetting);
        RestMLDeployModelAction restMLDeployModelAction = new RestMLDeployModelAction(this.mlFeatureEnabledSetting);
        RestMLUndeployModelAction restMLUndeployModelAction = new RestMLUndeployModelAction(this.clusterService, settings, this.mlFeatureEnabledSetting);
        RestMLRegisterModelMetaAction restMLRegisterModelMetaAction = new RestMLRegisterModelMetaAction(this.clusterService, settings);
        RestMLUploadModelChunkAction restMLUploadModelChunkAction = new RestMLUploadModelChunkAction(this.clusterService, settings);
        RestMLRegisterModelGroupAction restMLCreateModelGroupAction = new RestMLRegisterModelGroupAction(this.mlFeatureEnabledSetting);
        RestMLUpdateModelGroupAction restMLUpdateModelGroupAction = new RestMLUpdateModelGroupAction(this.mlFeatureEnabledSetting);
        RestMLGetModelGroupAction restMLGetModelGroupAction = new RestMLGetModelGroupAction(this.mlFeatureEnabledSetting);
        RestMLSearchModelGroupAction restMLSearchModelGroupAction = new RestMLSearchModelGroupAction(this.mlFeatureEnabledSetting);
        RestMLUpdateModelAction restMLUpdateModelAction = new RestMLUpdateModelAction(this.mlFeatureEnabledSetting);
        RestMLDeleteModelGroupAction restMLDeleteModelGroupAction = new RestMLDeleteModelGroupAction(this.mlFeatureEnabledSetting);
        RestMLCreateConnectorAction restMLCreateConnectorAction = new RestMLCreateConnectorAction(this.mlFeatureEnabledSetting);
        RestMLGetConnectorAction restMLGetConnectorAction = new RestMLGetConnectorAction(this.clusterService, settings, this.mlFeatureEnabledSetting);
        RestMLDeleteConnectorAction restMLDeleteConnectorAction = new RestMLDeleteConnectorAction(this.mlFeatureEnabledSetting);
        RestMLSearchConnectorAction restMLSearchConnectorAction = new RestMLSearchConnectorAction(this.mlFeatureEnabledSetting);
        RestMemoryCreateConversationAction restCreateConversationAction = new RestMemoryCreateConversationAction();
        RestMemoryGetConversationsAction restListConversationsAction = new RestMemoryGetConversationsAction();
        RestMemoryCreateInteractionAction restCreateInteractionAction = new RestMemoryCreateInteractionAction();
        RestMemoryGetInteractionsAction restListInteractionsAction = new RestMemoryGetInteractionsAction();
        RestMemoryDeleteConversationAction restDeleteConversationAction = new RestMemoryDeleteConversationAction();
        RestMLUpdateConnectorAction restMLUpdateConnectorAction = new RestMLUpdateConnectorAction(this.mlFeatureEnabledSetting);
        RestMemorySearchConversationsAction restSearchConversationsAction = new RestMemorySearchConversationsAction(this.mlFeatureEnabledSetting);
        RestMemorySearchInteractionsAction restSearchInteractionsAction = new RestMemorySearchInteractionsAction();
        RestMemoryGetConversationAction restGetConversationAction = new RestMemoryGetConversationAction();
        RestMemoryGetInteractionAction restGetInteractionAction = new RestMemoryGetInteractionAction();
        RestMLCreateControllerAction restMLCreateControllerAction = new RestMLCreateControllerAction(this.mlFeatureEnabledSetting);
        RestMLGetControllerAction restMLGetControllerAction = new RestMLGetControllerAction(this.mlFeatureEnabledSetting);
        RestMLUpdateControllerAction restMLUpdateControllerAction = new RestMLUpdateControllerAction(this.mlFeatureEnabledSetting);
        RestMLDeleteControllerAction restMLDeleteControllerAction = new RestMLDeleteControllerAction(this.mlFeatureEnabledSetting);
        RestMLGetAgentAction restMLGetAgentAction = new RestMLGetAgentAction(this.mlFeatureEnabledSetting);
        RestMLDeleteAgentAction restMLDeleteAgentAction = new RestMLDeleteAgentAction(this.mlFeatureEnabledSetting);
        RestMemoryUpdateConversationAction restMemoryUpdateConversationAction = new RestMemoryUpdateConversationAction();
        RestMemoryUpdateInteractionAction restMemoryUpdateInteractionAction = new RestMemoryUpdateInteractionAction();
        RestMemoryGetTracesAction restMemoryGetTracesAction = new RestMemoryGetTracesAction();
        RestMLSearchAgentAction restMLSearchAgentAction = new RestMLSearchAgentAction(this.mlFeatureEnabledSetting);
        RestMLListToolsAction restMLListToolsAction = new RestMLListToolsAction(this.toolFactories);
        RestMLGetToolAction restMLGetToolAction = new RestMLGetToolAction(this.toolFactories);
        RestMLGetConfigAction restMLGetConfigAction = new RestMLGetConfigAction(this.mlFeatureEnabledSetting);
        RestMLBatchIngestAction restMLBatchIngestAction = new RestMLBatchIngestAction();
        RestMLCancelBatchJobAction restMLCancelBatchJobAction = new RestMLCancelBatchJobAction();
        RestMLMcpToolsRegisterAction restMLRegisterMcpToolsAction = new RestMLMcpToolsRegisterAction(this.toolFactories, this.clusterService, this.mlFeatureEnabledSetting);
        RestMLMcpToolsRemoveAction restMLRemoveMcpToolsAction = new RestMLMcpToolsRemoveAction(this.clusterService, this.mlFeatureEnabledSetting);
        RestMLMcpToolsListAction restMLListMcpToolsAction = new RestMLMcpToolsListAction(this.mlFeatureEnabledSetting);
        RestMLMcpToolsUpdateAction restMLMcpToolsUpdateAction = new RestMLMcpToolsUpdateAction(this.clusterService, this.mlFeatureEnabledSetting);
        RestMcpServerAction restMcpServerAction = new RestMcpServerAction(this.mlFeatureEnabledSetting);
        return Arrays.asList(new RestHandler[]{restMLStatsAction, restMLTrainingAction, restMLPredictionAction, restMLExecuteAction, restMLTrainAndPredictAction, restMLGetModelAction, restMLDeleteModelAction, restMLSearchModelAction, restMLUpdateModelAction, restMLGetTaskAction, restMLDeleteTaskAction, restMLSearchTaskAction, restMLProfileAction, restMLRegisterModelAction, restMLRegisterAgentAction, restMLDeployModelAction, restMLUndeployModelAction, restMLRegisterModelMetaAction, restMLUploadModelChunkAction, restMLCreateModelGroupAction, restMLUpdateModelGroupAction, restMLGetModelGroupAction, restMLSearchModelGroupAction, restMLDeleteModelGroupAction, restMLCreateConnectorAction, restMLGetConnectorAction, restMLDeleteConnectorAction, restMLSearchConnectorAction, restCreateConversationAction, restListConversationsAction, restCreateInteractionAction, restListInteractionsAction, restDeleteConversationAction, restMLUpdateConnectorAction, restSearchConversationsAction, restSearchInteractionsAction, restGetConversationAction, restGetInteractionAction, restMLCreateControllerAction, restMLGetControllerAction, restMLUpdateControllerAction, restMLDeleteControllerAction, restMLGetAgentAction, restMLDeleteAgentAction, restMemoryUpdateConversationAction, restMemoryUpdateInteractionAction, restMemoryGetTracesAction, restMLSearchAgentAction, restMLListToolsAction, restMLGetToolAction, restMLGetConfigAction, restMLBatchIngestAction, restMLCancelBatchJobAction, restMLRegisterMcpToolsAction, restMLRemoveMcpToolsAction, restMLListMcpToolsAction, restMLMcpToolsUpdateAction, restMcpServerAction});
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        FixedExecutorBuilder generalThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_general", Math.max(1, SkyliteExecutors.allocatedProcessors((Settings)settings) - 1), 100, "thread_pool.ml_commons.lucenia_ml_general", false);
        FixedExecutorBuilder sdkClientThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_sdkclient", SkyliteExecutors.allocatedProcessors((Settings)settings) * 4, 10000, "thread_pool.ml_commons.lucenia_ml_sdkclient", false);
        FixedExecutorBuilder registerModelThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_register", Math.max(4, SkyliteExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.lucenia_ml_register", false);
        FixedExecutorBuilder deployModelThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_deploy", Math.max(4, SkyliteExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.lucenia_ml_deploy", false);
        FixedExecutorBuilder executeThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_execute", SkyliteExecutors.allocatedProcessors((Settings)settings) * 4, 10000, "thread_pool.ml_commons.lucenia_ml_execute", false);
        FixedExecutorBuilder trainThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_train", Math.max(1, SkyliteExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.lucenia_ml_train", false);
        FixedExecutorBuilder predictThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_predict", SkyliteExecutors.allocatedProcessors((Settings)settings) * 2, 10000, "thread_pool.ml_commons.lucenia_ml_predict", false);
        FixedExecutorBuilder remotePredictThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_predict_remote", SkyliteExecutors.allocatedProcessors((Settings)settings) * 4, 10000, "thread_pool.ml_commons.lucenia_ml_predict_remote", false);
        FixedExecutorBuilder batchIngestThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_ingest", SkyliteExecutors.allocatedProcessors((Settings)settings) * 4, 30, "thread_pool.ml_commons.lucenia_ml_ingest", false);
        FixedExecutorBuilder mcpThreadPool = new FixedExecutorBuilder(settings, "lucenia_mcp_tools_sync", Math.max(1, SkyliteExecutors.allocatedProcessors((Settings)settings) - 1), 10, "thread_pool.ml_commons.lucenia_mcp_tools_sync", false);
        FixedExecutorBuilder agenticMemoryThreadPool = new FixedExecutorBuilder(settings, "lucenia_ml_agentic_memory", SkyliteExecutors.allocatedProcessors((Settings)settings) * 4, 10000, "thread_pool.ml_commons.lucenia_ml_agentic_memory", false);
        return Arrays.asList(generalThreadPool, registerModelThreadPool, deployModelThreadPool, executeThreadPool, trainThreadPool, predictThreadPool, remotePredictThreadPool, batchIngestThreadPool, sdkClientThreadPool, mcpThreadPool, agenticMemoryThreadPool);
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(KMeansParams.XCONTENT_REGISTRY, LinearRegressionParams.XCONTENT_REGISTRY, AnomalyDetectionLibSVMParams.XCONTENT_REGISTRY, SampleAlgoParams.XCONTENT_REGISTRY, FitRCFParams.XCONTENT_REGISTRY, BatchRCFParams.XCONTENT_REGISTRY, LocalSampleCalculatorInput.XCONTENT_REGISTRY, MetricsCorrelationInput.XCONTENT_REGISTRY, AnomalyLocalizationInput.XCONTENT_REGISTRY_ENTRY, RCFSummarizeParams.XCONTENT_REGISTRY, LogisticRegressionParams.XCONTENT_REGISTRY, TextEmbeddingModelConfig.XCONTENT_REGISTRY, AsymmetricTextEmbeddingParameters.XCONTENT_REGISTRY);
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(MLCommonsSettings.ML_COMMONS_TASK_DISPATCH_POLICY, MLCommonsSettings.ML_COMMONS_MAX_MODELS_PER_NODE, MLCommonsSettings.ML_COMMONS_ONLY_RUN_ON_ML_NODE, MLCommonsSettings.ML_COMMONS_SYNC_UP_JOB_INTERVAL_IN_SECONDS, MLCommonsSettings.ML_COMMONS_ML_TASK_TIMEOUT_IN_SECONDS, MLCommonsSettings.ML_COMMONS_MONITORING_REQUEST_COUNT, MLCommonsSettings.ML_COMMONS_MAX_REGISTER_MODEL_TASKS_PER_NODE, MLCommonsSettings.ML_COMMONS_MAX_ML_TASK_PER_NODE, MLCommonsSettings.ML_COMMONS_MAX_DEPLOY_MODEL_TASKS_PER_NODE, MLCommonsSettings.ML_COMMONS_TRUSTED_URL_REGEX, MLCommonsSettings.ML_COMMONS_NATIVE_MEM_THRESHOLD, MLCommonsSettings.ML_COMMONS_DISK_FREE_SPACE_THRESHOLD, MLCommonsSettings.ML_COMMONS_JVM_HEAP_MEM_THRESHOLD, MLCommonsSettings.ML_COMMONS_EXCLUDE_NODE_NAMES, MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN, MLCommonsSettings.ML_COMMONS_ENABLE_INHOUSE_PYTHON_MODEL, MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_ENABLE, MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_LIFETIME_RETRY_TIMES, MLCommonsSettings.ML_COMMONS_MODEL_AUTO_REDEPLOY_SUCCESS_RATIO, MLCommonsSettings.ML_COMMONS_ALLOW_MODEL_URL, MLCommonsSettings.ML_COMMONS_ALLOW_LOCAL_FILE_UPLOAD, MLCommonsSettings.ML_COMMONS_MODEL_ACCESS_CONTROL_ENABLED, MLCommonsSettings.ML_COMMONS_CONNECTOR_ACCESS_CONTROL_ENABLED, MLCommonsSettings.ML_COMMONS_TRUSTED_CONNECTOR_ENDPOINTS_REGEX, MLCommonsSettings.ML_COMMONS_REMOTE_MODEL_ELIGIBLE_NODE_ROLES, MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ELIGIBLE_NODE_ROLES, MLCommonsSettings.ML_COMMONS_REMOTE_INFERENCE_ENABLED, MLCommonsSettings.ML_COMMONS_LOCAL_MODEL_ENABLED, MLCommonsSettings.ML_COMMONS_MEMORY_FEATURE_ENABLED, MLCommonsSettings.ML_COMMONS_RAG_PIPELINE_FEATURE_ENABLED, MLCommonsSettings.ML_COMMONS_AGENT_FRAMEWORK_ENABLED, MLCommonsSettings.ML_COMMONS_MODEL_AUTO_DEPLOY_ENABLE, MLCommonsSettings.ML_COMMONS_CONNECTOR_PRIVATE_IP_ENABLED, MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FIELD, MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_COMPLETED_REGEX, MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_CANCELLED_REGEX, MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_CANCELLING_REGEX, MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_EXPIRED_REGEX, MLCommonsSettings.ML_COMMONS_REMOTE_JOB_STATUS_FAILED_REGEX, MLCommonsSettings.ML_COMMONS_CONTROLLER_ENABLED, MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INGESTION_ENABLED, MLCommonsSettings.ML_COMMONS_OFFLINE_BATCH_INFERENCE_ENABLED, MLCommonsSettings.ML_COMMONS_MAX_BATCH_INFERENCE_TASKS, MLCommonsSettings.ML_COMMONS_MAX_BATCH_INGESTION_TASKS, MLCommonsSettings.ML_COMMONS_BATCH_INGESTION_BULK_SIZE, MLCommonsSettings.ML_COMMONS_SAFE_DELETE_WITH_USAGE_CHECK, MLCommonsSettings.ML_COMMONS_MULTI_TENANCY_ENABLED, MLCommonsSettings.ML_COMMONS_MCP_SERVER_ENABLED, MLCommonsSettings.ML_COMMONS_MCP_CONNECTOR_ENABLED, MLCommonsSettings.REMOTE_METADATA_TYPE, MLCommonsSettings.REMOTE_METADATA_ENDPOINT, MLCommonsSettings.REMOTE_METADATA_REGION, MLCommonsSettings.REMOTE_METADATA_SERVICE_NAME);
    }

    public List<SearchPlugin.SearchExtSpec<?>> getSearchExts() {
        ArrayList searchExts = new ArrayList();
        searchExts.add(new SearchPlugin.SearchExtSpec("generative_qa_parameters", input -> new GenerativeQAParamExtBuilder(input), parser -> GenerativeQAParamExtBuilder.parse((XContentParser)parser)));
        searchExts.add(new SearchPlugin.SearchExtSpec("ml_inference", input -> new MLInferenceRequestParametersExtBuilder(input), parser -> MLInferenceRequestParametersExtBuilder.parse((XContentParser)parser)));
        return searchExts;
    }

    public Map<String, SearchProcessor.Factory<SearchRequestProcessor>> getRequestProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("question_rewrite", new GenerativeQARequestProcessor.Factory(() -> this.ragSearchPipelineEnabled), "ml_inference", new MLInferenceSearchRequestProcessor.Factory(parameters.client, parameters.namedXContentRegistry));
    }

    public Map<String, SearchProcessor.Factory<SearchResponseProcessor>> getResponseProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("retrieval_augmented_generation", new GenerativeQAResponseProcessor.Factory(this.client, () -> this.ragSearchPipelineEnabled), "ml_inference", new MLInferenceSearchResponseProcessor.Factory(parameters.client, parameters.namedXContentRegistry));
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.externalToolFactories = new HashMap();
        for (MLCommonsExtension extension : loader.loadExtensions(MLCommonsExtension.class)) {
            List<Tool.Factory<? extends Tool>> toolFactories = extension.getToolFactories();
            for (Tool.Factory<? extends Tool> toolFactory : toolFactories) {
                ToolAnnotation toolAnnotation = toolFactory.getClass().getDeclaringClass().getAnnotation(ToolAnnotation.class);
                if (toolAnnotation == null) {
                    throw new IllegalArgumentException("Missing ToolAnnotation for Tool " + toolFactory.getClass().getDeclaringClass().getSimpleName());
                }
                String annotationValue = toolAnnotation.value();
                this.externalToolFactories.put(annotationValue, toolFactory);
            }
        }
    }

    public Map<String, AbstractProcessor.Factory<?>> getProcessors(IngestProcessor.Parameters parameters) {
        NamedXContentRegistry contentRegistry = new NamedXContentRegistry(this.getNamedXContent());
        return Map.of("ml_inference", new MLInferenceIngestProcessor.Factory(parameters.scriptService, parameters.client, contentRegistry));
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        ArrayList<SystemIndexDescriptor> systemIndexDescriptors = new ArrayList<SystemIndexDescriptor>();
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-agent", "ML Commons Agent Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-config", "ML Commons Configuration Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-connector", "ML Commons Connector Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-controller", "ML Commons Controller Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-model-group", "ML Commons Model Group Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-model", "ML Commons Model Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-task", "ML Commons Task Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-memory-meta", "ML Commons Memory Meta Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-memory-message", "ML Commons Memory Message Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-stop-words", "ML Commons Stop Words Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-mcp-session-management", "ML Commons MCP session management Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-mcp-tools", "ML Commons MCP tools Index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".plugins-ml-jobs", "ML Commons Jobs Index"));
        return systemIndexDescriptors;
    }
}

