/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.ml.common.action.agents;

import io.lucenia.ml.common.rest.RestActionUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.ml.common.agent.MLAgent;
import io.skylite.ml.common.cluster.TenantAwareHelper;
import io.skylite.ml.common.settings.MLFeatureEnabledSetting;
import io.skylite.ml.common.transport.agent.MLAgentDeleteRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteAgentTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    private static final Logger log = LogManager.getLogger(DeleteAgentTransportAction.class);
    protected final Client client;
    private final MetadataClient sdkClient;
    protected final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteAgentTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, MetadataClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/lucenia/ml/agents/delete", transportService, actionFilters, MLAgentDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLAgentDeleteRequest mlAgentDeleteRequest = MLAgentDeleteRequest.fromActionRequest((ActionRequest)request);
        String agentId = mlAgentDeleteRequest.getAgentId();
        String tenantId = mlAgentDeleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, actionListener)) {
            return;
        }
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-agent")).id(agentId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListenerHelper.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block21: {
                    log.debug("Completed Get Agent Request, Agent id:{}", (Object)agentId);
                    if (throwable != null) {
                        Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (SkyliteExceptionsHelper.unwrap((Throwable)throwable, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            log.info("Failed to get Agent index", (Throwable)cause);
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("Failed to get agent index", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            log.error("Failed to get ML Agent {}", (Object)agentId);
                            wrappedListener.onFailure(cause);
                        }
                    } else {
                        try {
                            GetResponse gr;
                            GetResponse getResponse = gr = r.parser() == null ? null : GetResponse.fromXContent((XContentParser)r.parser());
                            assert (gr != null);
                            if (gr.isExists()) {
                                try (XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, gr.getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    MLAgent mlAgent = MLAgent.parse((XContentParser)parser);
                                    if (TenantAwareHelper.validateTenantResource((MLFeatureEnabledSetting)this.mlFeatureEnabledSetting, (String)tenantId, (String)mlAgent.getTenantId(), (ActionListener)wrappedListener)) {
                                        if (mlAgent.getIsHidden().booleanValue() && !isSuperAdmin) {
                                            wrappedListener.onFailure((Exception)new SkyliteStatusException("User doesn't have privilege to perform this operation on this agent", RestStatus.FORBIDDEN, new Object[0]));
                                        } else {
                                            DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-agent", agentId);
                                            try {
                                                this.sdkClient.deleteDataObjectAsync(((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build()).whenComplete((response, delThrowable) -> this.handleDeleteResponse((DeleteDataObjectResponse)response, (Throwable)delThrowable, tenantId, (ActionListener<DeleteResponse>)wrappedListener));
                                            }
                                            catch (Exception e) {
                                                log.error("Failed to delete ML agent: {}", (Object)agentId);
                                                wrappedListener.onFailure(e);
                                            }
                                        }
                                    }
                                    break block21;
                                }
                                catch (Exception e) {
                                    log.error("Failed to parse ml agent {}", (Object)agentId);
                                    wrappedListener.onFailure(e);
                                }
                                break block21;
                            }
                            wrappedListener.onFailure((Exception)new SkyliteStatusException("Fail to find ml agent", RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            log.error("Failed to delete ML agent: {}", (Object)agentId);
                            wrappedListener.onFailure(e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to delete ml agent {}", (Object)agentId);
            actionListener.onFailure(e);
        }
    }

    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String agentId, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SkyliteExceptionsHelper.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML Agent : {}", (Object)agentId);
            actionListener.onFailure(cause);
        } else {
            try {
                DeleteResponse deleteResponse = DeleteResponse.fromXContent((XContentParser)response.parser());
                log.info("Agent deletion result: {}, agent id: {}", (Object)deleteResponse.getResult(), (Object)response.id());
                actionListener.onResponse((Object)deleteResponse);
            }
            catch (Exception e) {
                actionListener.onFailure(e);
            }
        }
    }
}

